/* Widget displays info on the current segment, with possibility of config for editing description and tags */

IriSP.Widgets.CurrentSegmentInfobox = function(player, config){
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.CurrentSegmentInfobox.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.CurrentSegmentInfobox.prototype.defaults = {
    annotation_type: "chap",
    readonly: true,
    empty_message: false,
    pause_on_segment_end: false,
    // How long in milliseconds after segment's end can the player pause (less than 500 is unreliable)
    pause_latency: 500 
};

IriSP.Widgets.CurrentSegmentInfobox.prototype.template = 
    "<div class='Ldt-CurrentSegmentInfobox'>" 
    + "    <div class='Ldt-CurrentSegmentInfobox-Element Ldt-CurrentSegmentInfobox-Title'>{{title}}</div>" 
    + "    <div class='Ldt-CurrentSegmentInfobox-Element Ldt-CurrentSegmentInfobox-Description'>{{description}}</div>" 
    + "    <div class='Ldt-CurrentSegmentInfobox-Element Ldt-CurrentSegmentInfobox-Tags'>"
    + '        {{#tags.length}}'
    + '        <ul class="Ldt-CurrentSegmentInfobox-Tags-Ul">'
    + '        {{#tags}}'
    + '            {{#.}}'
    + '            <li class="Ldt-CurrentSegmentInfobox-Tags-Li">'
    + '                <span>{{.}}</span>'
    + '            </li>'
    + '            {{/.}}'
    + '        {{/tags}}'
    + '        </ul>'
    + '        {{/tags.length}}'
    + "    </div>" 
    + "</div>"

IriSP.Widgets.CurrentSegmentInfobox.prototype.messages = {
    fr : {
        empty : "Le player vidéo ne lit actuellement aucun segment"
    },
    en: {
        empty: "The player currently doesn't read any segment"
    }
}    
    
IriSP.Widgets.CurrentSegmentInfobox.prototype.draw = function() {
    var _this = this;
    this.segments = this.getWidgetAnnotations();
    
    this.renderTemplate();
    this.currentSegment = false;
    this.nextPauseOn = -1;
    this.clearBox();
    this.refresh();
    this.onMediaEvent("timeupdate", "refresh");
    this.onMediaEvent("settimerange", function(_timeRange){
        var _segmentBegin = _timeRange[0],
            _segmentEnd = _timeRange[1],
            _list = _this.segments.filter(function(_segment){
            return _segment.begin == _segmentBegin && _segment.end == _segmentEnd
        });
        if (_list.length >0){
            if (_this.currentSegment.id != _list[0].id){
                _this.currentSegment = _list[0];
                _data = {
                    title: _this.currentSegment.title,
                    description : _this.currentSegment.description,
                    tags : _this.currentSegment.getTagTexts()
                }
                _this.$.html(Mustache.to_html(_this.template, _data))
            }
        }
    });
}

IriSP.Widgets.CurrentSegmentInfobox.prototype.refresh = function() {
    if(!this.media.getTimeRange()){
        var _currentTime = this.media.getCurrentTime();
        var _list = this.segments.filter(function(_segment){
            return (_segment.begin <= _currentTime && _segment.end >= _currentTime);
        })
        
        if (_list.length > 0){
            if (this.currentSegment.id != _list[0].id){
                this.currentSegment = _list[0];
                _data = {
                    title: this.currentSegment.title,
                    description : this.currentSegment.description,
                    tags : this.currentSegment.getTagTexts()
                }
                this.$.html(Mustache.to_html(this.template, _data))
            }
        }
        else {
            this.currentSegment = false;
            this.clearBox();
        }
    }
}

IriSP.Widgets.CurrentSegmentInfobox.prototype.clearBox = function(){
    var _empty_message = this.l10n.empty
    if (this.empty_message) {
        _empty_message = this.empty_message
    }
    this.$.find(".Ldt-CurrentSegmentInfobox").html("<div class='Ldt-CurrentSegmentInfobox-Element Ldt-CurrentSegmentInfobox-NoSegment'>"+_empty_message+"</div>");
}