# Accès aux vues scénario

Pour générer une vue de scénario, il suffit d'appeler les url suivantes en source d'une iframe. Les url contiennent : 

* un identifiant de projet d’annotation (voir ci-dessus pour récupérer manuellement l’identifiant d’un projet)
* un ticket d’authentification CAS

### Scénario élève/annotation de segment en mode individuel

    https://appiri.enteduc.fr/remie/remie/workunit/segments_single?project_id=<:id>&casticket=<:ticket> 

* <:id> est l'id du projet considéré
* <:ticket> est le ticket d'authentification CAS 

### Scénario élève/annotation de segment en mode groupe    

    https://appiri.enteduc.fr/remie/remie/workunit/segments_group?project_id=<:id>&group_mode=true&casticket=<:ticket>

* <:id> est l'id du projet considéré
* <:ticket> est le ticket d'authentification CAS
Note: Le nom du paramètre du ticket CAS (par défaut “casticket”) est configurable de notre côté, si jamais il ne respecte pas les conventions de nommage d’Itop.

### Scénario professeur
(à implémenter)

### Scénario “marqueurs”
(à implémenter)

# Dupliquer un projet existant lors de l’instanciation d’un grain:

Un endpoint de l’API permet de dupliquer un projet existant. Pour cela il faut faire une requête POST à l’adresse suivante: 

    https://appiri.enteduc.fr/remie/api/ldt/1.0/projects?format=json&source=<:project_id>&publish=true&casticket=<:ticket>

* <:ticket> est le ticket d'authentification CAS
* <:project_id>: L’id du projet que l’on souhaite dupliquer

La requête POST doit être accompagnée de données sous la forme d’une chaîne de caractère de type json, selon le format suivant: 

	{
	“meta”: { 
	“dc:creator”: “<:user>”,
	“dc:contributor”: “<:user>”,
	“dc:title”: “<:title>”, 
	“dc:description”: “<:description>”, 
	"dc:created": "",
	            "dc:modified": "",
	            "dc:description": "",
	            "iricle:status": 2'
	},  
	"views": [],
	"lists": [],
	"annotation-types": [],
	"medias": [],
	"tags": [],
	"annotations": []
	}

* <:user>: L’utilisateur considéré comme “créateur” du nouveau projet. Cet utilisateur doit avoir accès en lecture au projet d’origine
* <:title>: Le titre que prendra la copie du projet dupliqué (optionnel, prendra le même titre que le projet initial si non-renseigné)
* <:description> : La description que prendea la copie du projet dupliqué (optionnelle, prendra le même titre que le projet initial si non-renseigné)

Dans la réponse à cette requête POST, le header “Location” contient l’URL à requêter (GET) pour obtenir les informations sur le projet créé. Il est possible d’en extraire l’id du projet afin de générer les scénario.
