# Authentication test env for Remie

## prerequisite
- php >= 5.4
- Laravel requirements :
    + Mcrypt PHP Extension
    + OpenSSL PHP Extension
    + Mbstring PHP Extension
    + Tokenizer PHP Extension
- docker (+boot2docker for OSX)
- node + npm ( or iojs + npm)
- jdk >= 7
- maven

Autre solution : utiliser Homestead : http://laravel.com/docs/5.0/homestead

## CAS server
If using boot2docker:
```shell
boot2docker init
boot2docker up
```

```shell
mvn clean package
docker build -t iri-research/cas-basic .
docker run -p 8080:8080 -p 8443:8443 --addhost homestead.app:192.168.10.10 -d iri-research/cas-basic
```

## LDT
For testing with runserver:
```shell
python manage.py runserver 0.0.0.0:8001
```
Edit config.py according to config.py.tmpl:

    CAS_SERVER_URL = "https://192.168.59.103:8443/cas/"
    CAS_IGNORE_REFERER = True
    CAS_REDIRECT_UTL = "/ldt/"

Note: for CAS_SERVER_URL, the ip address is the IP of the docker container. If using boot2docker it's given to you after "boot2docker up".

Add the following line to the /etc/hosts file of the machine running the LDT platform:

    192.168.10.10 homestead.app

## Client server
```shell
curl -sS https://getcomposer.org/installer | php
php composer.phar install
cp .env.example .env
```

edit .env to match environement:
* LDT_URL is http://192.168.x.x:8001 (assuming you ran runserver on port 8001), the ip adress is the one of the machine running ldt as seen on your local network. On mac it can be found using the Apple menu > System Preferences > Network
* For testing purposes: TEST_PROJECT_ID is the id of a project that was created for user casuser and unpublished. Its json data will be displayed on the Laravel home view to show the results of the CAS proxy authentication process.

```shell
npm install
./node_modules/.bin/gulp
php artisan serve
```

### If using Homestead
Instead of the above commands you just have to edit the .env and boot the vm to start the Laravel app
```
vagrant up
```
The code is located in /home/vagrant/Code

The vm will be accessible on ip 192.168.10.10, you can change it by editing the homestead/conf/homestead.yaml file. NOTE: if you change it then when running the docker container you have the change the add-host option accordingly and the /etc/hosts file of the machine running the LDT platform.

## Using the app

The app is accessible on the hostname homestead.app.
