<?php namespace TestCAS\Http\Controllers;

use Cas;
use phpCAS;

class HomeController extends Controller {

    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
    */

    /**
    * Create a new controller instance.
    *
    * @return void
    */
    public function __construct()
    {
        $this->middleware('auth.cas');
    }

    /**
    * Show the application dashboard to the user.
    *
    * @return Response
    */
    public function index()
    {
        $pt="Error getting PT";
        $pt=phpCAS::retrievePT(env("LDT_URL")."/api/ldt/1.0/projects/".env("TEST_PROJECT_ID")."/?format=json", $err_code, $err_msg);
        $ch=curl_init(env("LDT_URL")."/api/ldt/1.0/projects/".env("TEST_PROJECT_ID")."/?format=json&casticket=".$pt);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $proxiedRequestResponse=curl_exec($ch);
        curl_close($ch);

        $loginUrl=env("LDT_URL")."/accounts/cas/login";

        return view('home')->with(
          array("pt" => $pt, "err_code" => $err_code, "err_msg" => $err_msg, "proxiedRequestResponse" => $proxiedRequestResponse, 'loginUrl' => $loginUrl)
        );
    }

    /**
    * logout
    *
    * @return Response
    */
    public function logout()
    {
        cas::logout(['service'=>url('/')]);
        return redirect()->route('index');
    }

}
