"""remieplt URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/dev/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Add a URL to urlpatterns:  url(r'^blog/', include(blog_urls))
"""
from ldt.auth.views import login as pf_login
from ldt.text import VERSION_STR

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.views.generic import RedirectView

from remie.views import RemieSegmentsView, RemieIframeTesterView

js_info_dict = {
    'packages': ('django.contrib.admin',),
}

urlpatterns = [
    url(r'^admin/', include(admin.site.urls)),
    url(r'^i18n/', include('django.conf.urls.i18n')),

    url(r'^ldt/', include('ldt.ldt_utils.urls')),
    url(r'^user/', include('ldt.user.urls')),
    url(r'^api/', include('ldt.api.urls')),
    url(r'^api/' + VERSION_STR + '/text/', include('ldt.text.urls')),

    url(r'^auth_accounts/', include('registration.backends.simple.urls')),

    url(r'^accounts/', include('social.apps.django_app.urls', namespace='social')),
    url(r'^accounts/login/$',pf_login,{'template_name': 'registration/login.html'},name='auth_login'),
    url(r'^accounts/cas/login/$', 'django_cas_ng.views.login'),
    url(r'^accounts/cas/logout/$', 'django_cas_ng.views.logout'),
    url(r'^oauth/', include('oauth_provider.urls')),

    url(r'^remie/iframetester$', RemieIframeTesterView.as_view(), name="remie_iframe_tester"),

    url(r'^remie/workunit/segments$', RemieSegmentsView.as_view(), name="remie_segment"),
    url(r'^remie/workunit/groupsegment$', RemieSegmentsView.as_view(), name="remie_groupsegment"),
    url(r'^remie/workunit/marker', RemieSegmentsView.as_view(), name="remie_marker"),
    url(r'^remie/workunit/teacher', RemieSegmentsView.as_view(), name="remie_teacher"),

    url(r'^/?$', RedirectView.as_view(url='ldt'), name="remie_iframe_container"),

    url(r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),

    url(r'^short/(?P<base62_id>[A-Za-z0-9]+)$', 'shortener.views.follow', name="shortener_follow")

]

urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
