from django.shortcuts import render_to_response
from django.template import RequestContext
from django.views.generic import View
from django.conf import settings

P3P_HEADER = getattr(settings, "P3P_HEADER", "")

class RemieIframeTesterView(View):
    """
        A view for testing purposes that allows user to select which iframe view to test
    """
    template_name = "remie/iframe_tester.html"
    
    def get(self, request):
        return render_to_response(self.template_name, context_instance=RequestContext(request))

class RemieIframeHashView(View):
    
    template_name="remie/iframe_hash.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        scenario = request.GET.get("scenario", "segments_single") # scenario to put in iframe
        if scenario not in ["segments_single", "segments_group", "teacher", "markers", "segments_preview", "markers_preview"]:
            scenario = "segments_single"
        current_user = request.user
        render_data = {
            "scenario": scenario,
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))


class RemieIframeView(View):
    
    template_name="" # Template of the iframe view
    
    def add_p3p_header(self, response):
        if P3P_HEADER:
            response["P3P"] = P3P_HEADER
        return response
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return self.add_p3p_header(render_to_response(self.template_name, render_data, context_instance=RequestContext(request)))


class RemieSegmentsSingleView(RemieIframeView):
    """
        The view with the segment-scenario for single user
    """
    template_name = "remie/iframe_segments_single.html"    


class RemieSegmentsGroupView(RemieIframeView):
    """
        The view with the segment-scenario for group
    """
    template_name = "remie/iframe_segments_group.html"


class RemieSegmentsPreviewView(RemieIframeView):
    """
        The view with the segment-scenario for previews
    """
    template_name = "remie/iframe_segments_preview.html"
    

class RemieMarkersView(RemieIframeView):
    """
        The view with the markers-scenario 
    """
    template_name = "remie/iframe_markers.html"
    

class RemieMarkersTeacherView(RemieIframeView):
    """
        The view with the markers-scenario 
    """
    template_name = "remie/iframe_markers_teacher.html"


class RemieMarkersPreviewView(RemieIframeView):
    """
        The view with the markers-scenario 
    """
    template_name = "remie/iframe_markers_preview.html"


class RemieTeacherView(RemieIframeView):
    """
        The view with the teacher-scenario 
    """
    template_name = "remie/iframe_teacher.html"