# Accès aux vues scénario

Pour générer une vue de scénario, il suffit d'appeler les url suivantes en source d'une iframe. Les url contiennent : 

* un identifiant de projet d’annotation (voir ci-dessus pour récupérer manuellement l’identifiant d’un projet)

### Scénario élève/annotation de segment en mode individuel

    https://appiri.enteduc.fr/remie/remie/workunit/segments_single?project_id=<:id>&casticket=<:ticket> 

* <:id> est l'id du projet considéré

### Scénario élève/annotation de segment en mode groupe    

    https://appiri.enteduc.fr/remie/remie/workunit/segments_group?project_id=<:id>&group_mode=true&casticket=<:ticket>

* <:id> est l'id du projet considéré

### Scénario professeur
    
    https://appiri.enteduc.fr/remie/remie/workunit/segments_teacher?project_id=<:id>

* <:id> est l'id du projet considéré

### Scénario “marqueurs”

    https://appiri.enteduc.fr/remie/remie/workunit/markers?project_id=<:id>

* <:id> est l'id du projet considéré


# Dupliquer un projet existant lors de l’instanciation d’un grain:

Un endpoint de l’API permet de dupliquer un projet existant. Pour cela il faut faire une requête POST à l’adresse suivante: 

    https://appiri.enteduc.fr/remie/api/ldt/1.0/projects?format=json&source=<:project_id>&publish=true&username=<:username>&api_key=<:api_key>

* <:project_id>: L’id du projet que l’on souhaite dupliquer
* <:username>: L’id de l’utilisateur qui sera affecté comme “créateur” du projet (à priori admin, expliqué plus bas)
* <:api_key>: La clé d’API qui permettra d’authentifier l’utilisateur (expliqué plus bas)


La requête POST doit être accompagnée de données sous la forme d’une chaîne de caractère de type json, selon le format suivant: 

	{
	“meta”: { 
	“dc:creator”: “<:user>”,
	“dc:contributor”: “<:user>”,
	“dc:title”: “<:title>”, 
	“dc:description”: “<:description>”, 
	"dc:created": "",
	            "dc:modified": "",
	            "dc:description": "",
	            "iricle:status": 2'
	},  
	"views": [],
	"lists": [],
	"annotation-types": [],
	"medias": [],
	"tags": [],
	"annotations": []
	}

* <:user>: L’utilisateur considéré comme “créateur” du nouveau projet. Cet utilisateur doit avoir accès en lecture au projet d’origine
* <:title>: Le titre que prendra la copie du projet dupliqué (optionnel, prendra le même titre que le projet initial si non-renseigné)
* <:description> : La description que prendea la copie du projet dupliqué (optionnelle, prendra le même titre que le projet initial si non-renseigné)

Username et API key:
Pour authentifier l’utilisateur afin de dupliquer le projet, il faut joindre à la requête les paramètres “username” et “api_key” comme indiqué plus haut. username est l’utilisateur qui possèdera le projet (à priori l’admin, le même utilisateur que celui qui aura créé les projets initiaux).
L’API key peut être obtenue sur la plateforme en étant authentifié en tant qu’utilisateur admin.

Il faut aller sur l’interface admin dont le lien se trouve en haut à droite de l’écran, menu Tastypie -> Api Keys pour obtenir la liste des utilisateurs et leurs clés d'API associées.

