"""
Django settings for remieplt project.

Generated by 'django-admin startproject' using Django 1.8.2.

For more information on this file, see
https://docs.djangoproject.com/en/dev/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/dev/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os, remieplt

BASE_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/dev/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = None

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = (
    'django_extensions',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'haystack',
    'corsheaders',
    'tastypie',
    'guardian',
    'taggit',
    'taggit_templatetags',
    'registration',
    'oauth_provider',
    'social.apps.django_app.default',
    'sorl.thumbnail',
    'ldt',
    'ldt.core',
    'ldt.security',
    'ldt.user',
    'ldt.ldt_utils',
    'ldt.text',
    'ldt.management',
    'ldt.indexation',
    'chunked_uploads',
    'shortener',
    'remie'
)

MIDDLEWARE_CLASSES = (
#    'django.middleware.cache.UpdateCacheMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.gzip.GZipMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'ldt.ldt_utils.middleware.swfupload.SWFUploadMiddleware',
    'ldt.ldt_utils.middleware.userprofile.LanguageMiddleware',
    'ldt.security.middleware.SecurityMiddleware',
    'remie.middleware.cas_proxy_auth.CASAuthenticationMiddleware',
#    'django.middleware.cache.FetchFromCacheMiddleware',
)

ROOT_URLCONF = 'remieplt.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(os.path.dirname(os.path.dirname(__file__)), 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.i18n',
                'django.template.context_processors.media',
                'django.template.context_processors.static',
                'django.template.context_processors.tz',
                'django.contrib.messages.context_processors.messages',
                'ldt.utils.context_processors.ldt_context',
            ],
        },
    },
]

WSGI_APPLICATION = 'remieplt.wsgi.application'


# Database
# https://docs.djangoproject.com/en/dev/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.abspath(os.path.join(BASE_DIR, '..', '..', 'run', 'db.sqlite3')),
    }
}


# Internationalization
# https://docs.djangoproject.com/en/dev/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True

ugettext = lambda s: s

LANGUAGES = (
    ('fr', ugettext('French')),
    ('en', ugettext('English')),
    ('ja', ugettext('Japanese')),
)

SITE_ID = 1

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/dev/howto/static-files/

STATIC_URL = '/static/'


AUTH_USER_MODEL = 'user.LdtUser'

AUTHENTICATION_BACKENDS = (
#    'social.backends.open_id.OpenIdAuth',
#    'social.backends.google.GoogleOpenId',
#    'social.backends.twitter.TwitterOAuth',
#    'social.backends.facebook.FacebookOAuth2',
    'guardian.backends.ObjectPermissionBackend',
    'django.contrib.auth.backends.ModelBackend',
    'django_cas_ng.backends.CASBackend',
)


ADMINS = (
    #('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS



# Registration settings
ACCOUNT_ACTIVATION_DAYS = 7
REGISTRATION_OPEN = False


# ldt settings
DECOUPAGE_BLACKLIST = (
     "de_PPP",
)

ZIP_BLACKLIST = (
     "__MACOSX",
)

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 2
LDT_MAX_FRAGMENT_PER_SEARCH = 3
LDT_RESULTS_PER_PAGE = 10
LDT_MAX_CONTENTS_PER_PAGE = 10
LDT_MAX_PROJECTS_PER_PAGE = 10
LDT_FRONT_MEDIA_PER_PAGE = 9
LDT_FRONT_PROJECTS_PER_PAGE = 12
LDT_MEDIA_IN_RESULTS_PAGE = 6

TEST_WEBSERVER_ADDRPORT = "127.0.0.1:8888"

EMPTY_MEDIA_EXTERNALID = None

CAS_URLPARAMETER_NAME = "casticket"
CAS_VERSION = "remie.cas.CASClientRemie"

SOCIAL_AUTH_COMPLETE_URL_NAME  = 'complete'
SOCIAL_AUTH_ASSOCIATE_URL_NAME = 'associate_complete'

AUTO_INDEX_AFTER_SAVE = True

ANONYMOUS_USER_ID = -1

WEB_VERSION = remieplt.get_version()

DIVISIONS_FOR_STAT_ANNOTATION = 64

FRONT_TAG_LIST = []

DEFAULT_CONTENT_ICON = "thumbnails/contents/content_default_icon.png"
DEFAULT_PROJECT_ICON = "thumbnails/projects/project_default_icon.png"
DEFAULT_USER_ICON = "thumbnails/users/user_default_icon.png"
DEFAULT_GROUP_ICON = "thumbnails/groups/group_default_icon.png"
PROFILE_IMG_MAX_SIZE = 1000000

USE_GROUP_PERMISSIONS = ['Project', 'Content', 'Media']
FORBIDDEN_STREAM_URL = "rtmp://media.iri.centrepompidou.fr/ddc_player/mp4:video/forbidden_stream.mp4?old_path="
PUBLIC_GROUP_NAME = 'everyone'
MAX_USERS_SEARCH = 20

SYNTAX = {
          '++' : 'OK',
          '--' : 'KO',
          '==' : 'REF',
          '??' : 'Q'
          }

EXTERNAL_STREAM_SRC = ['youtube.com', 'dailymotion.com', 'vimeo.com']

HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.simple_backend.SimpleEngine',
    },
}
HAYSTACK_SIGNAL_PROCESSOR = 'ldt.indexation.signals.LdtSignalProcessor'
LDT_INDEXATION_INSERT_BATCH_SIZE = 5000


#Cors headers for API
CORS_ORIGIN_ALLOW_ALL = True
CORS_EXPOSE_HEADERS = ('Location',)


MAX_TAG_LENGTH = 255
FORCE_LOWERCASE_TAGS = True

TAGGIT_TAGCLOUD_MIN = 1.0
TAGGIT_TAGCLOUD_MAX = 12.0

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'

HTTPLIB2_DISABLE_SSL_CERTIFICATE_VALIDATION = True
