#! /usr/bin/env python

from django.core.management import setup_environ
from ldtplatform import settings

setup_environ(settings)

from django.db import connections
import lxml.etree
from ldt.ldt_utils.models import Media, Content

cur = connections['migration_rs'].cursor()

# Get all "regarssignes" contents
cur.execute("SELECT * from ldt_content")
rows = cur.fetchall()
s = "Show me the databases:\n"
for row in rows:
    s += "\n   " + str(row)
    # (id-0, u'iri_id'-1, u'iri_url'-2, u'videopath'-3, datetime creation_date-4, datetime update_date-5, u'title'-6, description-7, eternal_id-8)
    # (1, u'laurentcantet_entrelesmurs', u'laurentcantet_entrelesmurs/laurentcantet_entrelesmurs.iri', u'rtmp://media.iri.centrepompidou.fr/ddc_player/video/regardssignes/', datetime.datetime(2010, 2, 17, 5, 24, 13, 69794, tzinfo=psycopg2.tz.FixedOffsetTimezone(offset=60, name=None)), datetime.datetime(2010, 2, 17, 5, 24, 13, 91656, tzinfo=psycopg2.tz.FixedOffsetTimezone(offset=60, name=None)), u'Entre Les Murs', None, None)
    # Get duration from the iri file
    prePath = settings.MEDIA_ROOT +  u"ldt/"
    doc = lxml.etree.parse(prePath + row[2])
    res = doc.xpath("/iri/body/medias/media[@id='video']/video")
    if len(res) > 0:
        try:
            dur = int(res[0].get(u'dur', 0) or 0)
        except:
            dur = 3600000
    else:
        dur = 3600000
    # Build platform media and platform content from "regarssignes" contents
    media = Media.objects.create(external_id=row[8], creation_date=row[4], update_date=row[5], videopath=row[3], duration=dur,
                                 description=row[7], title=row[6], src=(row[1] + u".flv"), mimetype_field="('video/x-flv', None)")
    media.save()
    
    content = Content.objects.create(iri_id=row[1], iriurl=row[2], creation_date=row[4], update_date=row[5], title=row[6], description=row[7],
                                 content_creation_date=row[4], duration=dur, media_obj=media)
    content.save()
    