#!/usr/bin/env bash

SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
SCRIPTNAME=`basename "$0"`

usage() {
  echo -n "${SCRIPTNAME} [CONFIG] [DB_FILE_PATH]

Dump the database to <DB_FILE_PATH> using ansible.
Beware this will replace the dest file without warning
"
}

if [[ "$#" -ne 2 ]]; then
    usage
    exit 1
fi

config=${1}
db_file_path=${2}

case $config in
    test) configOK=true;;
    prod) configOK=true;;
    *)    configOK=false;;
esac

if [[ "$configOK" = false ]]; then
    usage
    exit 1
fi

pushd "$SCRIPTPATH"

ANSIBLE_SSH_PIPELINING=1 ANSIBLE_STDOUT_CALLBACK=debug ansible-playbook -v -i "./hosts/hosts.$config" -l "$config" ./dump_db.yml --extra-vars "db_file_path='${db_file_path}'" --ask-vault-pass

popd
