#!/usr/bin/env bash

SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
SCRIPTNAME=`basename "$0"`

usage() {
  echo -n "${SCRIPTNAME} [CONFIG] [DB_FILE_PATH] [ORIGIN_URL]

Deploy the database <DB_FILE_PATH> using ansible.
Replacing the <ORIGIN_URL> by the destination url in the ansible config (rc_wp_home).
"
}

if [[ "$#" -ne 3 ]]; then
    usage
    exit 1
fi

config=${1}
db_file_path=${2}
origin_url=${3}

case $config in
    test) configOK=true;;
    prod) configOK=true;;
    *)    configOK=false;;
esac

if [[ "$configOK" = false ]]; then
    usage
    exit 1
fi

pushd "$SCRIPTPATH"

ANSIBLE_SSH_PIPELINING=1 ANSIBLE_STDOUT_CALLBACK=debug ansible-playbook -v -i "./hosts/hosts.$config" -l "$config" ./deploy_db.yml --extra-vars "db_file_path='${db_file_path}' origin_url='${origin_url}'" --ask-vault-pass

popd
