# Recherchecontributive deployment

The deployment is done with ansible.
A pipfile is available to set it up.
This deployment take

## Set the deploy environement

- `pipenv install`
- `pipenv shell`

## Start the deploy

- `deploy.sh <profile> <hg tag>`. Example: `deploy.sh test tip`

## configuration file:

- `hosts/hosts.<profile>`
- `group_vars/<profile>.yml`
- `host_vars/<hostname>/base.yml` base `host_vars/base.yml.tmpl`

## Database deploy

- `deploy_db.sh [CONFIG] [DB_FILE_PATH] [ORIGIN_URL]`

With:
- `CONFIG`: test or prod
- `DB_FILE_PATH`: The database definition file (SQL)
- `ORIGIN_URL`: The site base URL matching the database file

This script call the `deploy_db.yml` ansible script and perform the following operations
- copy the sql file to the server
- apply the sql file with wp-cli `db` command
- search and replace the origin url (wp-cli search-replace)
- set `template_root` option (wp-cli option)
- delete _site_transient_update_themes and _site_transient_theme_roots options (wp-cli option)
- update admin password (wp-cli user update)
- flush cache (wp-cli cache flush)


## Database dump

- `dump_db.sh [CONFIG] [DB_FILE_PATH]`

With:
- `CONFIG`: test or prod
- `DB_FILE_PATH`: The database definition file (SQL)

This script call the `dump_db.sql` ansible script and perform the following operation
- create a temporary file on the remote host
- dump the content of the database into this file (wp-cli db export)
- fetch the file and write it to the givent path
- delete the temporary file

**WARNING** : This command write to the destination file and replace it without warning