<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer">
		<?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
		<div class="site-info">
			<?php if ( ! empty( $blog_info ) ) : ?>
				<a class="site-name" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
			<?php endif; ?>
			<?php
			if ( function_exists( 'the_privacy_policy_link' ) ) {
				the_privacy_policy_link( '', '<span role="separator" aria-hidden="true"></span>' );
			}
			?>
			<?php if ( has_nav_menu( 'footer' ) ) : ?>

			<?php endif; ?>
			<div class="site-partners">
				<a target="_blank" href="https://generation-thunberg.org"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_aagt.jpg" alt="logo association des amis de la génération Thunberg"/></a>
				<a target="_blank" href="https://www.iri.centrepompidou.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_iri.jpg" alt="logo iri"/></a>
				<a target="_blank" href="https://seinesaintdenis.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_seinesaintdenis.jpg" alt="logo seine-saint-denis"/></a>
				<a target="_blank" href="http://www.ac-creteil.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_creteil.jpg" alt="logo academie de créteil"/></a>
				<a target="_blank" href="https://www.fondationdefrance.org/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_fondationfrance.jpg" alt="logo foundation de france"/></a>
				<a target="_blank" href="https://www.caissedesdepots.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_caissedepots.jpg" alt="logo caisse des dépôts"/></a>
				<a target="_blank" href="https://www.caf.fr/allocataires/caf-de-la-seine-saint-denis/accueil"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_caf93.jpg" alt="logo caf 93"/></a>
				<a><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_fondbois.jpg" alt="logo fond des bois"/></a>
			</div><!-- partners -->
		</div><!-- .site-info -->

	</footer><!-- #colophon -->

</div><!-- #page -->

	<script>

	// Tooltips
	var $j = jQuery.noConflict();

	$j(function () {
			$j(document).tooltip({
				content: function () {
					return $j(this).prop('title');
				},
				show: null, 
				close: function (event, ui) {
					ui.tooltip.hover(
		
					function () {
						$j(this).stop(true).fadeTo(400, 1);
					},
		
					function () {
						$j(this).fadeOut("400", function () {
							$j(this).remove();
						})
					});
				}
			});
		});
  	</script>

<?php wp_footer(); ?>

</body>
</html>
