#!/usr/bin/env bash

SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
SCRIPTNAME=`basename "$0"`

usage() {
  echo -n "${SCRIPTNAME} [CONFIG] [VERSION]

Deploy the <config> using ansible.
config must be in the following list : test, prod
"
}

if [[ "$#" -ne 2 ]]; then
    usage
    exit 1
fi

config=${1}
VERSION=${2}

case $config in
    test) configOK=true;;
    prod) configOK=true;;
    *)    configOK=false;;
esac

if [[ "$configOK" = false ]]; then
    usage
    exit 1
fi

pushd "$SCRIPTPATH"

ANSIBLE_SSH_PIPELINING=1 ANSIBLE_STDOUT_CALLBACK=debug ansible-playbook -v -i "./hosts/hosts.$config" -l "$config" ./deploy.yml --extra-vars "rc_version=${VERSION}" --ask-vault-pass

popd
