<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer">
		<?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
		<div class="site-info">
			<?php if ( ! empty( $blog_info ) ) : ?>
				<a class="site-name" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
			<?php endif; ?>
			<?php
			if ( function_exists( 'the_privacy_policy_link' ) ) {
				the_privacy_policy_link( '', '<span role="separator" aria-hidden="true"></span>' );
			}
			?>
			<?php if ( has_nav_menu( 'footer' ) ) : ?>

			<?php endif; ?>
			<div class="site-partners">
				<a target="_blank" href="http://www.arsindustrialis.org/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_ars.jpg" alt="logo ars industrialis"/></a>
				<a target="_blank" href="https://www.iri.centrepompidou.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_iri.jpg" alt="logo iri"/></a>
				<a target="_blank" href="https://plainecommune.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_plaineco.jpg" alt="logo paline commune"/></a>
				<a target="_blank" href="https://www.mshparisnord.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_msh.jpg" alt="logo msh"/></a>
				<a target="_blank" href="https://www.3ds.com/fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_dassault.jpg" alt="logo dassault"/></a>
				<a target="_blank" href="https://www.orange.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_orange.jpg" alt="logo orange"/></a>
				<a target="_blank" href="https://www.societegenerale.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_socgen.jpg" alt="logo société générale"/></a>
				<a target="_blank" href="https://www.caissedesdepots.fr/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_caisse.jpg" alt="logo caisse des dépôts"/></a>
				<a target="_blank" href="https://www.fondation-afnic.fr"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_afnic.jpg" alt="logo fondation afnic"/></a>
			</div><!-- partners -->
		</div><!-- .site-info -->
	</footer><!-- #colophon -->

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
