# Recherchecontributive.org Website

This project is the website for recherchecontributive.org.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes. See deployment for notes on how to deploy the project on a live system.

### Prerequisites

What things you need to install the software and how to install them

  - docker
  - docker-compose
  - A code editor

In you local dns (/etc/hosts for example), map you Docker machine IP to the domain name `recherchecontributive.test`.

### Installing

Build docker images:

```
$ docker-compose build
```

Launch the project

```
$ docker-compose up
```
or
```
$ docker-compose up -d
```

import data.

```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root db import - < /path/to/recherchecontributive_dbase.sql
```

Replace strings in database:

```
docker-compose exec wp /var/www/html/vendor/bin/wp --allow-root search-replace https://recherchecontributive.org http://recherchecontributive.test:8080
```

Import media files:
```
$ tar -C src/web/app/ -zxf /path/to/recherchecontributive_media.tar.gz 
```

Navigate to http://recherchecontributive.test:8080.

## Data management

**!! BEWARE !!**: Do not launch the `docker-compose down` command before exporting data. This command delete the `db` container's data volume end therefore delete the database.

### Export database
```
$ docker-compose exec wp /var/www/html/vendor/bin/wp --allow-root db export --add-drop-table - > recherchecontributive_dbase_2019-04-19.sql
```

### Export media
```
$ tar zcf recherchecontributive_media_2019-04-19.tar.gz -C src/web/app/ uploads
```

### Import database

```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root db import - < recherchecontributive_dbase_2019-04-19.sql
```

If needed do a search replace after this to update the site urls:

```
$ docker-compose exec wp /var/www/html/vendor/bin/wp --allow-root search-replace https://recherchecontributive.org http://recherchecontributive.test:8080
```
Set the template root
```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root option set template_root "/var/www/html/web/wp/wp-content/themes"
```

delete options
```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root option delete _site_transient_update_themes
```
```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root option delete _site_transient_theme_roots
```


Or change the administration password
```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root user update admin --prompt=user_pass
```

Flush cache
```
$ docker-compose exec -T wp /var/www/html/vendor/bin/wp --allow-root cache flush
```


## Deployment

README.md in deploy folder

## Built With

* [Wordpress](https://wordpress.org/) - The CMS used

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://www.iri.centrepompidou.fr/dev/hg/recherchecontributive.org/tags). 

## Authors

* **Yves-Marie Haussonne** - *Initial work*

## License

This project is licensed under the CecCill License - see the [LICENSE.md](LICENSE.md) file for details

## Acknowledgments

* Hat tip to anyone whose code was used
* Wordpress: https://wordpress.org/
* Bedrock: https://roots.io/bedrock
* Docker for local wordpress development: https://urre.me/writings/docker-for-local-wordpress-development/

