from django.conf.urls import patterns, include, url
from polemictweet.views.home import root_home
from polemictweet.views.event import create_event, display_event, add_live, add_content
from polemictweet.views.group import create_group, display_group

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'polemictweet_site.views.home', name='home'),
    # url(r'^polemictweet_site/', include('polemictweet_site.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    url(r'^admin/', include(admin.site.urls)),
        
    url(r'^$', root_home, name='root_home'),
    url(r'^event_admin/create_event/$', create_event, name='create_event'),
    url(r'^event_admin/modif_event/(?P<event_slug>.*)$', create_event, name='modif_event'),
    url(r'^event_admin/add_live/(?P<event_slug>.*)$', add_live, name='add_live'),
    url(r'^event_admin/add_content/(?P<event_slug>.*)$', add_content, name='add_content'),
    url(r'^event/(?P<event_slug>.*)$', display_event, name='display_event'),
    url(r'^group_admin/create_group/$', create_group, name="create_group"),
    url(r'^group_admin/modif_group/(?P<group_slug>.*)$', create_group, name='modif_group'),
    url(r'^group/(?P<group_slug>.*)$', display_group, name='display_group'),
    (r'^i18n/', include('django.conf.urls.i18n')),
    (r'^tinymce/', include('tinymce.urls')),
)
