from django.conf import settings
from django.db import transaction
from django.core.urlresolvers import reverse
from django.shortcuts import render_to_response, redirect, render, get_object_or_404
from django.template import RequestContext
from polemictweet.models import Group
from polemictweet.forms import GroupForm
from django.utils.translation import ugettext as _, get_language
from django.forms.models import model_to_dict
from polemictweet.utils.translate_language import get_translation_languages
import sys
import logging

logger = logging.getLogger(__name__)

@transaction.commit_manually
def write_group_base(request, translation_languages, current_language, group_slug=None):
    group = None
    default_language = settings.LANGUAGES[0][0]
    if group_slug:
        instance_group = Group.objects.get(slug=group_slug) #@UndefinedVariable
    else:
        logger.debug("No group_slug") #@UndefinedVariable
        instance_group = None

    form_status = 'none' 
    if request.method == "POST":
        try:
            if instance_group is not None:
                group_instance_val = model_to_dict(instance_group)
            else:
                group_instance_val = {}
            group_form = GroupForm(request.POST, request.FILES, instance = instance_group)
            group_valid = group_form.is_valid()
            logger.debug("write_group_base : valid form: for instance : " + repr(instance_group)) #@UndefinedVariable
            
            if group_valid :               
                if form_status != "error":    
                    group = group_form.save()
                    form_status = 'saved'
            else:
                form_status = 'error'
        except Exception, e:
            transaction.rollback()
            __, value, traceback = sys.exc_info()
            return False, False, False, e, traceback
 
    else:
        form_status = 'empty'
        group_form = GroupForm(instance=instance_group)
               
    try:
        transaction.commit()
    except Exception, e:
        transaction.rollback()
        __, __, traceback = sys.exc_info()
        return False, False, False, e, traceback
        
    return group, group_form, form_status, "", ""

def create_group(request, group_slug = None):
    submit_action = request.REQUEST.get("submit_button", False) 
    current_language = get_language().split("-")[0]

    translation_languages = get_translation_languages()
    
    if submit_action=="close":
        return render_to_response('home.html', {'message': "You saved your group", 'translation_languages' : translation_languages, 'current_language' : current_language}, context_instance=RequestContext(request))

    else:
        group, group_form, form_status, e, traceback = write_group_base(request, translation_languages, current_language, group_slug)        
        if group_slug: 
            group_temp = Group.objects.get(slug=group_slug)

        if (group_form == False and form_status == False):
            message=_("An error occurred - Please try again or contact webmaster")
            title = _("Error")
            raise e, None, traceback
      
        if group_slug:
            create_group_action = reverse('polemictweet.views.group.create_group', kwargs={'group_slug':group_slug})

        else:
            create_group_action = reverse('polemictweet.views.group.create_group')

        if form_status=='saved' or form_status=='deleted':
            return redirect('display_group', group_slug = group.slug)
            #return render_to_response('home.html', {'message': "You saved your group", 'translation_languages' : translation_languages, 'current_language' : current_language, 'group' : group}, context_instance=RequestContext(request))
        else:
            return render_to_response('create_group.html', {'group_form': group_form, 'form_status': form_status, 'create_group_action': create_group_action,
                                                                        'group_slug': group_slug, 'translation_languages' : translation_languages, 'current_language' : current_language}, context_instance=RequestContext(request))


def display_group(request, group_slug):
    current_language = get_language().split("-")[0]

    try :
        group = Group.objects.get(slug=group_slug)
    except :
        return render_to_response('home.html', {'message': "The group doesn't exist", 'current_language' : current_language}, context_instance=RequestContext(request))
   
    return render_to_response('group.html',  {'message': 'you saved your group', 'group' : group, 'current_language' : current_language}, context_instance=RequestContext(request))