from django.conf import settings
from django.core.urlresolvers import reverse
from django.shortcuts import render_to_response
from django.template import RequestContext
from polemictweet.forms import  PartnerForm
from django.utils.translation import get_language
from polemictweet.utils.translate_language import get_translation_languages
import sys
import logging

logger = logging.getLogger(__name__)


def create_partner(request):
    submit_action = request.REQUEST.get("submit_button", False) 
    current_language = get_language().split("-")[0]
    translation_languages = get_translation_languages()
    
    if submit_action=="close":
        return render_to_response('home.html', {'message': "You didn't create any partner", 'translation_languages' : translation_languages, 'current_language' : current_language}, context_instance=RequestContext(request))
    
    else : 
        
        form_status = "none"
        if request.method == "POST" :
            partner_form = PartnerForm(request.POST, request.FILES)
            is_valid = partner_form.is_valid()
            if is_valid :
                partner_form.save()
                form_status = "saved"
        else:
            partner_form = PartnerForm()
                
        if form_status=='saved' or form_status=='deleted':
            return render_to_response('home.html', {'message': "You creates a partner", 'translation_languages' : translation_languages, 'current_language' : current_language}, context_instance=RequestContext(request))
        else :
            create_partner_action = reverse('polemictweet.views.partner.create_partner')       
            return render_to_response('create_partner.html', {'partner_form':partner_form, 'form_status': form_status,
                                                            'create_partner_action': create_partner_action, 'current_language' : current_language }, context_instance=RequestContext(request))
