from modeltranslation.translator import translator, TranslationOptions

from polemictweet.models import Event, Content, Group


class EventTranslationOptions(TranslationOptions):
    fields = ('title', 'description', 'program', 'event_image')

class ContentTranslationOptions(TranslationOptions):
    fields = ('display', 'program')

class GroupTranslationOptions(TranslationOptions):
    fields = ('title', 'description')


translator.register(Event, EventTranslationOptions)
translator.register(Content, ContentTranslationOptions)
translator.register(Group, GroupTranslationOptions)

