from django.core.management.base import NoArgsCommand
from django.db import connection
from django.core.management import call_command
from django.contrib.contenttypes.models import ContentType

class Command(NoArgsCommand):
    help = "Migrate existing database to Django 1.8"

    def handle_noargs(self, **options):
        # delete tables
        cursor = connection.cursor()
        for tname in [ "jogging_log", "auth_message",
                      "django_openid_consumer_association",
                      "django_openid_consumer_nonce",
                      "piston_consumer", "piston_nonce",
                      "piston_resource", "piston_token",
                      "south_migrationhistory", "social_auth_nonce",
                      "social_auth_association", "social_auth_usersocialauth"]:
            cursor.execute("DROP TABLE IF EXISTS \"%s\" CASCADE;" % tname)
        
        call_command('migrate', 'contenttypes', fake_initial=True, interactive=False)
        call_command('migrate', 'auth', fake_initial=True, interactive=False)
        call_command('migrate', 'user', fake_initial=True, interactive=False)
        call_command('migrate', 'default', interactive=False)
        call_command('migrate', 'oauth_provider', fake=True, interactive=False)
        call_command('migrate', fake_initial=True, interactive=False)
        
        
        ContentType.objects.filter(app_label="auth", model="user").delete()
        ContentType.objects.filter(app_label="user", model="userprofile").delete()
        ContentType.objects.filter(app_label="user", model="ldt").delete()
