'''
Imports amateur.iri.centrepompidou.fr/nouveaumonde files to ldt.iri
'''
import csv
import sys

import requests
from django.core.management.base import BaseCommand
from django.core import management
from lxml import etree
from django.db import connections
from ldt.ldt_utils import models


def create_source(iri_id):
    '''
    create .iri source
    '''
    return "https://media.iri.centrepompidou.fr/video/enmi/" + iri_id + ".mp4"
def create_iri_url(iri_url):
    '''
    create iri url
    '''
    return "http://amateur.iri.centrepompidou.fr" + iri_url


class Command(BaseCommand):
    '''
    command
    '''
    def add_arguments(self, parser):
        '''
        add arguments
        '''

        parser.add_argument('-i',
                            '--pathin',
                            dest='pathin',
                            default=None
                           )
        parser.add_argument('-o',
                            '--pathout',
                            dest='pathout',
                            default=None
                           )

    def get_duration(self, elem):
        '''
        get duration
        '''
        for element in self.mylist:
            element[0] = element[0][:len(element[0])-1]
            if elem == element[0]:
                element[1] = element[1][1:]
                root = etree.XML(element[1].encode('utf-8'), self.parser)
                duration = root.xpath('format')[0].get('duration')
                duration = duration[:7]
                return duration

    def change_annotations(self, iriin, ldtout):
        '''
        change annotations
        '''
        rootout = etree.XML(ldtout.encode('utf-8'), self.parser)
        rootin = etree.XML(iriin.encode('utf-8'), self.parser)
        ensembles = rootin.xpath('body/ensembles/ensemble')
        for ensemble in ensembles:
            idens = ensemble.get("id")
            decoups = ensemble.xpath('decoupage')
            rootout.xpath('annotations/content')[0].append(ensemble)
            for decoup in decoups:
                iddec = decoup.get("id")
                nouveaudecoup = '<decoupage idens=\"' + idens +'\" id=\"' + iddec +'\" tagsSelect=\"\"/>'
                nouveaudecxml = etree.fromstring(nouveaudecoup)
                rootout.xpath('displays/display/content')[0].append(nouveaudecxml)
        return etree.tostring(rootout)
    def handle(self, *args, **options):
        '''
        handle command
        '''
        pathin = options['pathin']
        pathout = options['pathout']
        if not pathin or not pathout:
            return "Error : specify path in and path out"
        try:
            csvfile = open(pathin, 'r')
            csvfile2 = open(pathout, 'wb')
        except IOError:
            self.stdout.write('file can\'t be opened')
            return

        cursor = connections['default2'].cursor()
        cursor.execute('SELECT ct.iri_id, ct.iriurl, ct.creation_date, ct.title, ct.description,\
                        pj.ldt_id, pj.ldt\
                        FROM ldt_content AS ct INNER JOIN ldt_ldtproject_contents\
                        AS ctpj ON ct.id = ctpj.content_id\
                        INNER JOIN ldt_ldtproject AS pj ON ctpj.ldtproject_id = pj.id;'
                      )
        amateurdata = cursor.fetchall()
        reload(sys)
        sys.setdefaultencoding('utf8')
        self.parser = etree.XMLParser(encoding='utf-8')
        self.myfile = csv.reader(csvfile)
        self.writefile = csv.writer(csvfile2)
        self.mylist = list(self.myfile)
        for mediaproj in amateurdata:
            iri_id = mediaproj[0]
            try:
                models.Project.objects.get(title='front project : %s' % iri_id)
                continue
            except models.Project.MultipleObjectsReturned:
                continue
            except models.Project.DoesNotExist:
                self.stdout.write('Media %s will be created'%iri_id)
            iriurl = mediaproj[1]
            #TODO set creationdate, title...
            # creationdate = mediaproj[2]
            # title = mediaproj[3]
            description = mediaproj[4]
            # ldt_id = mediaproj[5]
            # ldt = mediaproj[6]
            mysource = create_source(iri_id)
            myiriurl = create_iri_url(iriurl)
            myiri = requests.get(myiriurl)._content
            duration = self.get_duration(mysource)
            if requests.head(mysource).status_code == 200:
                management.call_command(
                    'createmediacontent',
                    source=mysource,
                    title=iri_id,
                    videopath='',
                    description=description,
                    duration=duration,
                    public=True,
                    creator='admin',
                    update=True
                    )
                myfrontproj = models.Project.objects.get(title='front project : %s' % iri_id)
                myfrontproj.ldt = self.change_annotations(myiri, myfrontproj.ldt)
                self.writefile.writerow([mysource,
                                         iri_id,
                                         models.Content.objects.get(title=iri_id).iri_id,
                                         myfrontproj.ldt_id
                                        ])
                self.stdout.write("Project changed")
                myfrontproj.save()
        csvfile.close()
        csvfile2.close()
