import platform

from lib_create_env import lib_generate_install_methods

system_str = platform.system()


INSTALLS = [ #(key,method, option_str, dict_extra_env)
    'LXML',
    'PSYCOPG2',
    #'MYSQL',
    'PIL', 
    'DJANGO',
    'DJANGO-EXTENSIONS',
    'DJANGO-REGISTRATION',
    'DJANGO-TAGGIT',
    'DJANGO-TAGGIT-TEMPLATETAGS',
    'HTTPLIB2',
    'OAUTH2',
    'SETUPTOOLS_HG',
    'DJANGO-OAUTH-PLUS',
    'OPENID',
    'SOCIAL_AUTH',
    'DJANGO_GUARDIAN',
    'SORL_THUMBNAIL',
    'HAYSTACK',
    'REQUESTS',
    'PYELASTICSEARCH',
    'WHOOSH',
    'MIMEPARSE',
    'SIX',
    'PYTHON-DATEUTIL',
    'PYYAML',
    'PYTHON-DIGEST',
    'DEFUSEDXML',
    'DJANGO-TASTYPIE',
    'DJANGO-CORS-HEADERS',
    'DJANGO-CHUNCKED-UPLOADS',
]

if system_str == "Linux":
    INSTALLS.insert(2, 'DISTRIBUTE')

OPTIONS_TO_ADD = ['clear', 'type_install=local', 'unzip_setuptools']
if system_str != 'Linux':
    OPTIONS_TO_ADD.append('use_distribute')

def generate_install_methods(path_locations, src_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, Logger, call_subprocess, INSTALLS, OPTIONS_TO_ADD)
