import sys
import os
import os.path
import shutil
import tarfile
import zipfile
import urllib
import platform
import patch
import struct
import glob
import re

join = os.path.join
system_str = platform.system()

URLS = {
    #'': {'setup': '', 'url':'', 'local':''},
    'DISTRIBUTE': {'setup': 'distribute', 'url':'http://pypi.python.org/packages/source/d/distribute/distribute-0.6.34.tar.gz', 'local':"distribute-0.6.34.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO': {'setup': 'django', 'url': 'https://github.com/IRI-Research/django/archive/d11d79737105223c99d15b3956837c1246f60441.tar.gz', 'local':"django-1.8.2.dev.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-EXTENSIONS': { 'setup': 'django-extensions', 'url':'https://github.com/django-extensions/django-extensions/archive/1.5.3.tar.gz', 'local':"django-extensions-1.5.3.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-REGISTRATION': { 'setup': 'django-registration', 'url':'https://github.com/macropin/django-registration/archive/v1.2.tar.gz', 'local':"django-registration-redux-1.2.tar.gz", 'install': {'method': 'easy_install', 'option_str': '-Z', 'dict_extra_env': None}},
    'DJANGO-TEMPLATETAG-SUGAR': { 'setup': 'django-templatetag-sugar', 'url': 'https://github.com/alex/django-templatetag-sugar/archive/1.0.tar.gz', 'local': 'django-templatetag-sugar-1.0.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-TAGGIT': { 'setup': 'django-taggit', 'url':'https://github.com/alex/django-taggit/archive/0.14.0.tar.gz', 'local':"django-taggit-0.14.0.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-TAGGIT-TEMPLATETAGS': { 'setup': 'django-taggit-templatetags', 'url':'https://github.com/feuervogel/django-taggit-templatetags/archive/d2216c9d1888e0739a04899a36e5149b5cbb3381.zip', 'local':"django-taggit-templatetags-0.4.5dev-r0.zip", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'OAUTH2': { 'setup': 'python-oauth2', 'url':"https://github.com/simplegeo/python-oauth2/tarball/hudson-python-oauth2-211", 'local':"oauth2-1.5.211.tar.gz", 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
    'HTTPLIB2': { 'setup': 'python-httplib2', 'url':'https://pypi.python.org/packages/source/h/httplib2/httplib2-0.9.1.tar.gz', 'local':"httplib2-0.9.1.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-OAUTH-PLUS': { 'setup': 'django-oauth-plus', 'url':'https://pypi.python.org/packages/source/d/django-oauth-plus/django-oauth-plus-2.2.6.tar.gz', 'local':"django-oauth-plus-2.2.6.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'OPENID': {'setup':'openid', 'url':'http://pypi.python.org/packages/source/p/python-openid/python-openid-2.2.5.tar.gz', 'local':"python-openid-2.2.5.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SOCIAL_AUTH': {'setup':'social_auth', 'url':'https://github.com/omab/python-social-auth/archive/v0.2.7.tar.gz', 'local':"python-social-auth-0.2.7.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO_GUARDIAN' : { 'setup': 'django-guardian', 'url':'https://github.com/TauPan/django-guardian/archive/django-guardian-1.2.6.dev.tar.gz', 'local':"django-guardian-1.2.6.dev.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SORL_THUMBNAIL' : { 'setup': 'sorl-thumbnail', 'url':'https://github.com/mariocesar/sorl-thumbnail/archive/v12.2.tar.gz', 'local':"sorl-thumbnail-12.2.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'LIBJPEG': {'setup': None, 'url':'jpegsrc.v9.tar.gz', 'local':'jpegsrc.v9.tar.gz', 'install': {'method': 'install_libjpeg', 'option_str': None, 'dict_extra_env': None}},
    'ZLIB': {'setup': None, 'url':'zlib-1.2.8.tar.gz', 'local':'zlib-1.2.8.tar.gz', 'install': {'method': 'install_zlib', 'option_str': None, 'dict_extra_env': None}},
    'HAYSTACK': {'setup': 'django-haystack', 'url': 'https://github.com/toastdriven/django-haystack/archive/v2.4.0.tar.gz', 'local': 'django-haystack-2.4.0.tar.gz', 'install':{'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'REQUESTS': {'setup': 'requests', 'url':'https://github.com/kennethreitz/requests/archive/v2.7.0.tar.gz', 'local':'requests-2.7.0.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'ELASTICSEARCH': {'setup': 'elasticsearch', 'url':'https://github.com/elastic/elasticsearch-py/archive/1.4.0.tar.gz', 'local':'elasticsearch-1.4.0.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYELASTICSEARCH': {'setup': 'pyelasticsearch', 'url':'https://pypi.python.org/packages/source/p/pyelasticsearch/pyelasticsearch-1.2.3.tar.gz', 'local':'pyelasticsearch-1.2.3.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'WHOOSH': {'setup': 'whoosh', 'url':'https://bitbucket.org/mchaput/whoosh/get/2.7.0.tar.gz', 'local':'whoosh-2.7.0.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'SETUPTOOLS_HG' : {'setup':'setuptools_hg', 'url':'https://bitbucket.org/jezdez/setuptools_hg/get/v0.4.tar.gz', 'local': 'setuptools_hg-0.4.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    # dependencies for Tastypie : mimeparse>=0.1.3, python-dateutil>=2.1, lxml, PyYAML (not necessary but we never know), python-digest, defusedxml
    'MIMEPARSE' : {'setup':'mimeparse', 'url':'http://pypi.python.org/packages/source/m/mimeparse/mimeparse-0.1.3.tar.gz', 'local': 'mimeparse-0.1.3.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'SIX' : {'setup':'six', 'url':'https://pypi.python.org/packages/source/s/six/six-1.9.0.tar.gz', 'local': 'six-1.9.0.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYTHON-DATEUTIL' : {'setup':'python-dateutil', 'url':'https://pypi.python.org/packages/source/p/python-dateutil/python-dateutil-2.1.tar.gz', 'local': 'python-dateutil-2.1.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYYAML' : {'setup':'pyyaml', 'url':'http://pypi.python.org/packages/source/P/PyYAML/PyYAML-3.11.tar.gz', 'local': 'PyYAML-3.11.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYTHON-DIGEST' : {'setup':'python-digest', 'url':'http://pypi.python.org/packages/source/p/python-digest/python-digest-1.7.tar.gz', 'local': 'python-digest-1.7.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'DEFUSEDXML' : {'setup':'defusedxml', 'url':'https://pypi.python.org/packages/source/d/defusedxml/defusedxml-0.4.1.tar.gz', 'local': 'defusedxml-0.4.1.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-TASTYPIE' : {'setup':'django-tastypie', 'url':'https://github.com/toastdriven/django-tastypie/archive/130cb64eb6c0e688b1efe3b9839fbd86f034b4ed.tar.gz', 'local': 'django-tastypie-0.12.2.dev0.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-CORS-HEADERS' : {'setup':'django-cors-headers', 'url':'https://github.com/ottoyiu/django-cors-headers/archive/1.0.0.tar.gz', 'local': 'django-cors-headers-1.0.0.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-CHUNCKED-UPLOADS' : {'setup': 'django-chuncked-uploads', 'url':'https://github.com/IRI-Research/django-chunked-uploads/archive/v0.6.tar.gz', 'local':'django-chunked-uploads-0.6.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'OAUTHLIB': { 'setup': 'oauthlib', 'url':"https://github.com/idan/oauthlib/archive/0.7.2.tar.gz", 'local':"oauthlib-0.7.2.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'URLLIB3': { 'setup': 'urllib3', 'url':'https://github.com/shazow/urllib3/archive/1.10.4.tar.gz', 'local':"urllib3-1.10.4.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SIMPLEJSON' : { 'setup': 'simplejson', 'url': 'https://github.com/simplejson/simplejson/archive/v3.6.5.tar.gz', 'local' : 'simplejson-3.6.5.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYJWT' : { 'setup': 'pyjwt', 'url': 'https://github.com/jpadilla/pyjwt/archive/1.1.0.tar.gz', 'local' : 'pyjwt-1.1.0.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYTHON-MIMEPARSE': { 'setup': 'python-mimeparse', 'url': 'https://pypi.python.org/packages/source/p/python-mimeparse/python-mimeparse-0.1.4.tar.gz', 'local' : 'python-mimeparse-0.1.4.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'REQUESTS-OAUTHLIB': { 'setup': 'requests-oauthlib', 'url': 'https://github.com/requests/requests-oauthlib/archive/v0.5.0.tar.gz', 'local' : 'requests-oauthlib-0.5.0.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SOUTH': { 'setup': 'South', 'url':'http://www.aeracode.org/releases/south/south-1.0.2.tar.gz', 'local':"south-1.0.2.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
}

if system_str == 'Windows':
    
    size = 8 * struct.calcsize("P")
    if size==32:
        mysqlres = "MySQL-python-1.2.3.win32-py2.7.exe"
    else:
        mysqlres = "MySQL-python-1.2.3.win-amd64-py2.7.exe"
    
    URLS.update({
        'PSYCOPG2': {'setup': 'psycopg2','url': 'psycopg2-2.4.6.win32-py2.7-pg9.2.2-release.exe', 'local':"psycopg2-2.4.6.win32-py2.7-pg9.2.2-release.exe", 'install': {'method': 'install_psycopg2', 'option_str': None, 'dict_extra_env': None}},
        'PIL': {'setup': 'pil', 'url': 'http://effbot.org/media/downloads/PIL-1.1.7.win32-py2.7.exe', 'local':"PIL-1.1.7.win32-py2.7.exe", 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
        'LXML': {'setup': 'lxml', 'url': 'http://pypi.python.org/packages/2.7/l/lxml/lxml-2.3-py2.7-win32.egg', 'local':"lxml-2.3-py2.7-win32.egg", 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
        'MYSQL': { 'setup': 'mysql-python', 'url': mysqlres, 'local': mysqlres, 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
    })
else:
    if system_str == "Darwin":
        lxml_options = {'STATIC_DEPS': 'true', 'LIBXML2_VERSION': '2.9.2', 'LIBXSLT_VERSION': '1.1.28', 'LIBICONV_VERSION': '1.14'}
        if os.path.exists('/usr/local/opt/xz'):
            if not os.path.exists('/usr/local/opt/libxml2'):
                sys.exit("You have installed xz with Homebrew but do not have libxml2 installed with Homebrew. Install libxml2 with Homebrew and try again.")
            lxml_options = {'LDFLAGS': '-L/usr/local/opt/libxml2/lib', 'CPPFLAGS': '-I/usr/local/opt/libxml2/include'}
        mysql_method = 'install_mysql'
    else:
        lxml_options = None
        mysql_method = 'pip'

    URLS.update({
        'PSYCOPG2': {'setup': 'psycopg2','url': 'http://initd.org/psycopg/tarballs/PSYCOPG-2-6/psycopg2-2.6.tar.gz', 'local':"psycopg2-2.6.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
        'PIL': {'setup': 'pillow', 'url': 'https://github.com/python-pillow/Pillow/archive/2.8.1.tar.gz', 'local':"Pillow-2.8.1.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
        'LXML': {'setup': 'lxml', 'url': 'lxml-3.2.1.tar.bz2', 'local': 'lxml-3.2.1.tar.bz2', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': lxml_options}},
        'MYSQL': { 'setup': 'mysql-python', 'url': 'http://downloads.sourceforge.net/project/mysql-python/mysql-python-test/1.2.4b4/MySQL-python-1.2.4b4.tar.gz', 'local':"MySQL-python-1.2.4b4.tar.gz", 'install': {'method': mysql_method, 'option_str': None, 'dict_extra_env': None}},
    })
    

class ResourcesEnv(object):

    def __init__(self, src_base, run_base, urls, normal_installs):
        self.src_base = src_base
        self.run_base = run_base
        self.URLS = {}
        self.__init_url(urls)
        self.NORMAL_INSTALL = normal_installs

    def get_src_base_path(self, fpath):
        return os.path.abspath(os.path.join(self.src_base, fpath)).replace("\\","/")

    def get_run_res_base_path(self, fpath):
        return os.path.abspath(os.path.join(self.run_base, 'res', fpath)).replace("\\","/")    
    
    def __add_package_def(self, key, dict):
        self.URLS[key] = dict
        
    def __init_url(self, urls):
        for key, url_dict in urls.items():
            url_dict_copy = url_dict.copy()
            if url_dict.get('install', {}).get('method','pip') == 'pip-req':
                get_base_path = self.get_run_res_base_path
            else:
                get_base_path = self.get_src_base_path
            if not url_dict['url'].startswith("http://"):
                url_dict_copy['url'] = get_base_path(url_dict['url'])
            url_dict_copy['local'] = get_base_path(url_dict['local'])

            self.__add_package_def(key, url_dict_copy )

def ensure_dir(dir, logger):
    logger.notify('Check directory %s' % dir)
    if not os.path.exists(dir):
        logger.notify('Creating directory %s' % dir)
        os.makedirs(dir)

def extend_parser(parser):    
    parser.add_option(
        '--index-url',
        metavar='INDEX_URL',
        dest='index_url',
        default='http://pypi.python.org/simple/',
        help='base URL of Python Package Index')
    parser.add_option(
        '--type-install',
        metavar='type_install',
        dest='type_install',
        help='type install : local, url, setup - default : local')
    parser.add_option(
        '--ignore-packages',
        metavar='ignore_packages',
        dest='ignore_packages',
        default=None,
        help='list of comma separated keys for package to ignore')
    parser.add_option(
        '--no-clear',
        metavar='do not clear env',
        dest='clear',
        default=True,
        action='store_false',
        help='do not clear env')



def install_psycopg2(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop):
    psycopg2_src = os.path.join(src_dir,"psycopg2.zip")
    shutil.copy(res_env.URLS['PSYCOPG2'][res_source_key], psycopg2_src)
    #extract psycopg2
    zf = zipfile.ZipFile(psycopg2_src)
    psycopg2_base_path = os.path.join(src_dir,"psycopg2")
    zf.extractall(psycopg2_base_path)
    zf.close()
    
    psycopg2_src_path = os.path.join(psycopg2_base_path, os.listdir(psycopg2_base_path)[0])
    shutil.copytree(os.path.join(psycopg2_src_path, 'psycopg2'), os.path.abspath(os.path.join(home_dir, 'Lib/site-packages', 'psycopg2')))
    shutil.copy(os.path.join(psycopg2_src_path, 'psycopg2-2.4.5-py2.7.egg-info'), os.path.abspath(os.path.join(home_dir, 'Lib/site-packages', 'site-packages')))
    

def install_mysql(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop):
    
    args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', res_env.URLS['MYSQL'][res_source_key]]                
    if option_str :
        args.insert(4,option_str)
    call_subprocess(args,
            cwd=os.path.abspath(tmp_dir),
            filter_stdout=filter_python_develop,
            show_stdout=True,
            extra_env=extra_env)

    mysqlconfig_output = []
    
    call_subprocess(['mysql_config', '--libmysqld-libs'],
        cwd=os.path.abspath(tmp_dir),
        filter_stdout=lambda line: mysqlconfig_output.append(line),
        show_stdout=True)
        
    mysqlconfig_output = "".join(mysqlconfig_output)
    m = re.search("\-L[\'\"]?([\w\/]+)[\'\"]?", mysqlconfig_output)
    if m:
        repdylibpath = m.group(1)
    else:
        repdylibpath = '/usr/local/mysql/lib'
        
    dyliblist = glob.glob(repdylibpath+"/libmysqlclient.*.dylib")
    def key_func(s):
        m = re.match(repdylibpath+"/libmysqlclient\.([\d]+)\.dylib", s)
        if m:
            return int(m.group(1))
        else:
            return sys.maxint
    dyliblist.sort(key=key_func)
    
    if dyliblist:
        dylibpath = dyliblist[0]
    else:
        dylibpath = '/usr/local/mysql/lib/libmysqlclient.18.dylib'
        
    dylibname = os.path.basename(dylibpath)    
    sopath = os.path.join(os.path.abspath(lib_dir), 'site-packages', '_mysql.so')
    
    call_subprocess(['install_name_tool', '-change', dylibname, dylibpath, sopath],
        cwd=os.path.abspath(tmp_dir),
        filter_stdout=filter_python_develop,
        show_stdout=True)


def gen_install_comp_lib(lib_name, lib_key, configure_options=[], configure_env={}):
    
    def install_lib(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop):
        lib_src = os.path.join(src_dir,lib_name+".tar.gz")
        logger.notify("Copy %s to %s " % (res_env.URLS[lib_key][res_source_key],lib_src))
        shutil.copy(res_env.URLS[lib_key][res_source_key], lib_src)
        tf = tarfile.open(lib_src,'r:gz')
        lib_base_path = os.path.join(src_dir, lib_name) 
        logger.notify("Extract %s to %s " % (lib_name,lib_base_path))
        tf.extractall(lib_base_path)
        tf.close()
        
        lib_src_path = os.path.join(lib_base_path, os.listdir(lib_base_path)[0])
        
        
        context_map = {
            'option_str' : option_str,
            'home_dir': os.path.abspath(home_dir),
            'lib_dir': os.path.abspath(lib_dir),
            'tmp_dir': os.path.abspath(tmp_dir),
            'src_dir': os.path.abspath(src_dir),
        }
        
        configure_options_trans = map(lambda s: s % context_map, configure_options)
        configure_env_trans = {k: s % context_map for k,s in configure_env.items()}
    
        logger.notify(lib_name + " configure in " + lib_src_path)
        call_subprocess(['./configure', '--prefix='+os.path.abspath(home_dir)] + configure_options_trans,
                        cwd=os.path.abspath(lib_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True,
                        extra_env=configure_env_trans
                        )

        logger.notify(lib_name + " make in " + lib_src_path)
        call_subprocess(['make'],
                        cwd=os.path.abspath(lib_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)
    
        logger.notify(lib_name + "make install in " + lib_src_path)
        call_subprocess(['make', 'install'],
                        cwd=os.path.abspath(lib_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)
    return install_lib

install_libjpeg = gen_install_comp_lib("libjpeg", "LIBJPEG", ['--enable-shared'], {})
install_zlib = gen_install_comp_lib("zlib", "ZLIB", [], {})

#osx_extra_env = {'ARCHFLAGS': '-Wno-error=unused-command-line-argument-hard-error-in-future', 'CFLAGS': '-Qunused-arguments', 'CPPFLAGS': '-Qunused-arguments'}
osx_extra_env = {}

def lib_generate_install_methods(path_locations, src_base, run_base, Logger, call_subprocess, normal_installs, options_to_add=None, urls= None):
    
    all_urls = URLS.copy()
    if urls is not None:
        all_urls.update(urls)
        
    res_env = ResourcesEnv(src_base, run_base, all_urls, normal_installs)

    def filter_python_develop(line):
        if not line.strip():
            return Logger.DEBUG
        for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                       'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                       'creating ', 'Copying ']:
            if line.startswith(prefix):
                return Logger.DEBUG
        return Logger.NOTIFY
    
    
    def normal_install(key, res_path, method, option_str, extra_env, res_source_key, home_dir, tmp_dir, res_env, logger, call_subprocess):
        logger.notify("Install %s from %s with %s" % (key,res_path,method))
        if method == 'pip':
            if sys.platform == 'win32':
                args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'pip')), 'install', res_path]
            else:
                args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', res_path]
            if option_str :
                args.append(option_str)
            if res_source_key == 'local':
                if extra_env is None:
                    extra_env = {}
                args.insert(2, '-f')
                args.insert(3, res_env.get_src_base_path(""))
                args.insert(4, '--no-index')
            logger.notify("Install %s from %s with %s args %s " % (key,res_path,method, repr(args)))
            call_subprocess(args,
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True,
                    extra_env=extra_env)
        if method == 'pip-req':
            if sys.platform == 'win32':
                args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'pip')), 'install', '-r', res_path]
            else:
                args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-r', res_path]
            if option_str :
                args.append(option_str)
            if res_source_key == 'local':
                if extra_env is None:
                    extra_env = {}
                args.insert(2, '-f')
                args.insert(3, res_env.get_src_base_path(""))
                args.insert(4, '--no-index')
            logger.notify("Install %s from %s with %s args %s " % (key,res_path,method, repr(args)))
            call_subprocess(args,
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True,
                    extra_env=extra_env)
        else:
            if sys.platform == 'win32':
                args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'easy_install')), res_path]
            else:
                args = [os.path.abspath(os.path.join(home_dir, 'bin', 'easy_install')), res_path]
            if option_str :
                args.insert(1,option_str)
            call_subprocess(args,
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True,
                    extra_env=extra_env)
 
    
    def after_install(options, home_dir):
        
        global logger
        
        verbosity = options.verbose - options.quiet
        logger = Logger([(Logger.level_for_integer(2-verbosity), sys.stdout)])

        
        home_dir, lib_dir, inc_dir, bin_dir = path_locations(home_dir)
        base_dir = os.path.dirname(home_dir)
        src_dir = os.path.join(home_dir, 'src')
        tmp_dir = os.path.join(home_dir, 'tmp')
        ensure_dir(src_dir, logger)
        ensure_dir(tmp_dir, logger)
        system_str = platform.system()
                
        res_source_key = getattr(options, 'type_install') if hasattr(options, 'type_install') else 'local' #.get('type_install', 'local')
        if res_source_key is None:
            res_source_key = 'local'
        
        ignore_packages = []
        
        if system_str == 'Windows':
            default_install_options = {'method': 'easy_install', 'option_str': None, 'dict_extra_env': {}}
        else:
            default_install_options = {'method': 'pip', 'option_str': None, 'dict_extra_env': {}}
            
        if options.ignore_packages :
            ignore_packages = options.ignore_packages.split(",")
        
        logger.indent += 2
        try:    
            for key in res_env.NORMAL_INSTALL:
                install_options = None
                if isinstance(key, dict):
                    install_options = key.get('install', default_install_options)
                    install_options['method'] = 'pip-req'
                    res_path = res_env.get_run_res_base_path(key['requirement'])
                else:
                    if key not in res_env.URLS:
                        logger.notify("%s not found in def : passing" % (key,))
                    install_options = res_env.URLS[key].get('install', None)
                    res_path = res_env.URLS[key][res_source_key]
                if install_options is None:
                    install_options = default_install_options
                method = install_options.get('method', default_install_options['method'])
                option_str = install_options.get('option_str', default_install_options['option_str'])
                extra_env = install_options.get('dict_extra_env', default_install_options['dict_extra_env'])
                if not extra_env:
                    extra_env = {}
                    
                if 'TMPDIR' not in extra_env:
                    extra_env['TMPDIR'] = os.path.abspath(tmp_dir)
                if system_str == 'Darwin':
                    for flag_key, flag_value in iter(osx_extra_env.items()):
                        flags = extra_env.get(flag_key, '')
                        if flag_value not in flags:
                            #flags += " -Wno-error=unused-command-line-argument-hard-error-in-future"
                            flags += " "+flag_value
                            extra_env[flag_key] = flags.strip()
                    
                #isinstance(lst, (list, tuple))
                if key not in ignore_packages:
                    logger.notify("install %s with method %s" % (key, repr(method)))
                    if callable(method):
                        method(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop)
                    elif method in globals() and callable(globals()[method]) and method not in ['pip', 'easy_install']:  
                        globals()[method](option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop)
                    else:
                        normal_install(key, res_path, method, option_str, extra_env, res_source_key, home_dir, tmp_dir, res_env, logger, call_subprocess)
                            
            logger.notify("Clear source dir")
            shutil.rmtree(src_dir)
    
        finally:
            logger.indent -= 2
        script_dir = join(base_dir, bin_dir)
        logger.notify('Run "%s Package" to install new packages that provide builds'
                      % join(script_dir, 'easy_install'))
    
    def adjust_options(options, args):
        if not options_to_add:
            return
        for opt,opt_val in options_to_add.items():
            #if not hasattr(options,test_opt) or getattr(options, test_opt) is None:
            setattr(options, opt, opt_val)

    return adjust_options, extend_parser, after_install

