# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('ldtplatform', '0001_correct_oauth_provider_secret_size')
    ]

    database_operations = [
        migrations.RunSQL("ALTER TABLE oauth_provider_nonce ADD COLUMN \"timestamp\" integer DEFAULT 1375699511;", migrations.RunSQL.noop),
        migrations.RunSQL("ALTER TABLE oauth_provider_nonce ADD CONSTRAINT oauth_provider_nonce_timestamp_check CHECK (\"timestamp\" >= 0);", migrations.RunSQL.noop),
        migrations.RunSQL("ALTER TABLE oauth_provider_nonce ALTER COLUMN \"timestamp\" SET NOT NULL;", migrations.RunSQL.noop),
        migrations.RunSQL("CREATE INDEX oauth_provider_nonce_d7e6d55b ON oauth_provider_nonce USING btree (\"timestamp\")", migrations.RunSQL.noop),
        migrations.RunSQL("ALTER TABLE oauth_provider_resource RENAME TO oauth_provider_scope;", migrations.RunSQL.noop),
        migrations.RunSQL("ALTER TABLE oauth_provider_token RENAME resource_id  TO scope_id;", migrations.RunSQL.noop),
        migrations.RunSQL("ALTER TABLE oauth_provider_token ALTER COLUMN scope_id DROP NOT NULL;", migrations.RunSQL.noop),
    ]

    state_operations = [
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            database_operations=database_operations,
            state_operations=state_operations)
    ]
    
    