      * Summary: error handling
      * Description: the API used to report errors
      *
      * Copy: See Copyright for the status of this software.
      *
      * Author: Patrick Monnerat <pm@datasphere.ch>, DATASPHERE S.A.

      /include "libxmlrpg/parser"

      /if not defined(XML_ERROR_H__)
      /define XML_ERROR_H__

      * xmlErrorLevel:
      *
      * Indicates the level of an error

     d xmlErrorLevel   s             10i 0 based(######typedef######)           enum
     d  XML_ERR_NONE   c                   0
     d  XML_ERR_WARNING...                                                      A simple warning
     d                 c                   1
     d  XML_ERR_ERROR  c                   2                                    A recoverable error
     d  XML_ERR_FATAL  c                   3                                    A fatal error

      * xmlErrorDomain:
      *
      * Indicates where an error may have come from

     d xmlErrorDomain  s             10i 0 based(######typedef######)           enum
     d  XML_FROM_NONE  c                   0
     d  XML_FROM_PARSER...                                                      XML parser
     d                 c                   1
     d  XML_FROM_TREE  c                   2                                    Tree module
     d  XML_FROM_NAMESPACE...                                                   XML Namespace module
     d                 c                   3
     d  XML_FROM_DTD   c                   4                                    DTD validation
     d  XML_FROM_HTML  c                   5                                    HTML parser
     d  XML_FROM_MEMORY...                                                      Memory allocator
     d                 c                   6
     d  XML_FROM_OUTPUT...                                                      serialization code
     d                 c                   7
     d  XML_FROM_IO    c                   8                                    Input/Output stack
     d  XML_FROM_FTP   c                   9                                    FTP module
     d  XML_FROM_HTTP  c                   10                                   HTTP module
     d  XML_FROM_XINCLUDE...                                                    XInclude processing
     d                 c                   11
     d  XML_FROM_XPATH...                                                       XPath module
     d                 c                   12
     d  XML_FROM_XPOINTER...                                                    XPointer module
     d                 c                   13
     d  XML_FROM_REGEXP...                                                      Regexp module
     d                 c                   14
     d  XML_FROM_DATATYPE...                                                    W3C XML Schm Dtatype
     d                 c                   15
     d  XML_FROM_SCHEMASP...                                                    W3C XML Schm parser
     d                 c                   16
     d  XML_FROM_SCHEMASV...                                                    W3C XML Schm valid.
     d                 c                   17
     d  XML_FROM_RELAXNGP...                                                    Relax-NG parser
     d                 c                   18
     d  XML_FROM_RELAXNGV...                                                    Relax-NG validator
     d                 c                   19
     d  XML_FROM_CATALOG...                                                     Catalog module
     d                 c                   20
     d  XML_FROM_C14N  c                   21                                   Canonicalization
     d  XML_FROM_XSLT  c                   22                                   Engine from libxslt
     d  XML_FROM_VALID...                                                       DTD valid. w/ ctxt
     d                 c                   23
     d  XML_FROM_CHECK...                                                       Error check module
     d                 c                   24
     d  XML_FROM_WRITER...                                                      xmlwriter module
     d                 c                   25
     d  XML_FROM_MODULE...                                                      Dyn. loaded module
     d                 c                   26
     d  XML_FROM_I18N  c                   27                                   Mod hdlg char conv
     d  XML_FROM_SCHEMATRONV...                                                 Schematron valid
     d                 c                   28
     d  XML_FROM_BUFFER...                                                      Buffers module
     d                 c                   29
     d  XML_FROM_URI   c                   30                                   URI module

      * xmlError:
      *
      * An XML Error instance.

     d xmlErrorPtr     s               *   based(######typedef######)

     d xmlError        ds                  based(xmlErrorPtr)
     d                                     align qualified
     d  domain                       10i 0                                      Libpart raising err
     d  code                         10i 0                                      Error code
     d  message                        *                                        char *
     d  level                              like(xmlErrorLevel)                  Error severity
     d  file                           *                                        File name
     d  line                         10i 0                                      Line number
     d  str1                           *                                        char *
     d  str2                           *                                        char *
     d  str3                           *                                        char *
     d  int1                         10i 0                                      Extra number info
     d  int2                         10i 0                                      Error column
     d  ctxt                           *                                        void *
     d  node                           *                                        void *

      * xmlParserError:
      *
      * This is an error that the XML (or HTML) parser can generate

     d xmlParserErrors...
     d                 s             10i 0 based(######typedef######)           enum
     d  XML_ERR_OK     c                   0
     d  XML_ERR_INTERNAL_ERROR...
     d                 c                   1
     d  XML_ERR_NO_MEMORY...
     d                 c                   2
     d  XML_ERR_DOCUMENT_START...
     d                 c                   3
     d  XML_ERR_DOCUMENT_EMPTY...
     d                 c                   4
     d  XML_ERR_DOCUMENT_END...
     d                 c                   5
     d  XML_ERR_INVALID_HEX_CHARREF...
     d                 c                   6
     d  XML_ERR_INVALID_DEC_CHARREF...
     d                 c                   7
     d  XML_ERR_INVALID_CHARREF...
     d                 c                   8
     d  XML_ERR_INVALID_CHAR...
     d                 c                   9
     d  XML_ERR_CHARREF_AT_EOF...
     d                 c                   10
     d  XML_ERR_CHARREF_IN_PROLOG...
     d                 c                   11
     d  XML_ERR_CHARREF_IN_EPILOG...
     d                 c                   12
     d  XML_ERR_CHARREF_IN_DTD...
     d                 c                   13
     d  XML_ERR_ENTITYREF_AT_EOF...
     d                 c                   14
     d  XML_ERR_ENTITYREF_IN_PROLOG...
     d                 c                   15
     d  XML_ERR_ENTITYREF_IN_EPILOG...
     d                 c                   16
     d  XML_ERR_ENTITYREF_IN_DTD...
     d                 c                   17
     d  XML_ERR_PEREF_AT_EOF...
     d                 c                   18
     d  XML_ERR_PEREF_IN_PROLOG...
     d                 c                   19
     d  XML_ERR_PEREF_IN_EPILOG...
     d                 c                   20
     d  XML_ERR_PEREF_IN_INT_SUBSET...
     d                 c                   21
     d  XML_ERR_ENTITYREF_NO_NAME...
     d                 c                   22
     d  XML_ERR_ENTITYREF_SEMICOL_MISSING...
     d                 c                   23
     d  XML_ERR_PEREF_NO_NAME...
     d                 c                   24
     d  XML_ERR_PEREF_SEMICOL_MISSING...
     d                 c                   25
     d  XML_ERR_UNDECLARED_ENTITY...
     d                 c                   26
     d  XML_WAR_UNDECLARED_ENTITY...
     d                 c                   27
     d  XML_ERR_UNPARSED_ENTITY...
     d                 c                   28
     d  XML_ERR_ENTITY_IS_EXTERNAL...
     d                 c                   29
     d  XML_ERR_ENTITY_IS_PARAMETER...
     d                 c                   30
     d  XML_ERR_UNKNOWN_ENCODING...
     d                 c                   31
     d  XML_ERR_UNSUPPORTED_ENCODING...
     d                 c                   32
     d  XML_ERR_STRING_NOT_STARTED...
     d                 c                   33
     d  XML_ERR_STRING_NOT_CLOSED...
     d                 c                   34
     d  XML_ERR_NS_DECL_ERROR...
     d                 c                   35
     d  XML_ERR_ENTITY_NOT_STARTED...
     d                 c                   36
     d  XML_ERR_ENTITY_NOT_FINISHED...
     d                 c                   37
     d  XML_ERR_LT_IN_ATTRIBUTE...
     d                 c                   38
     d  XML_ERR_ATTRIBUTE_NOT_STARTED...
     d                 c                   39
     d  XML_ERR_ATTRIBUTE_NOT_FINISHED...
     d                 c                   40
     d  XML_ERR_ATTRIBUTE_WITHOUT_VALUE...
     d                 c                   41
     d  XML_ERR_ATTRIBUTE_REDEFINED...
     d                 c                   42
     d  XML_ERR_LITERAL_NOT_STARTED...
     d                 c                   43
     d  XML_ERR_LITERAL_NOT_FINISHED...
     d                 c                   44
     d  XML_ERR_COMMENT_NOT_FINISHED...
     d                 c                   45
     d  XML_ERR_PI_NOT_STARTED...
     d                 c                   46
     d  XML_ERR_PI_NOT_FINISHED...
     d                 c                   47
     d  XML_ERR_NOTATION_NOT_STARTED...
     d                 c                   48
     d  XML_ERR_NOTATION_NOT_FINISHED...
     d                 c                   49
     d  XML_ERR_ATTLIST_NOT_STARTED...
     d                 c                   50
     d  XML_ERR_ATTLIST_NOT_FINISHED...
     d                 c                   51
     d  XML_ERR_MIXED_NOT_STARTED...
     d                 c                   52
     d  XML_ERR_MIXED_NOT_FINISHED...
     d                 c                   53
     d  XML_ERR_ELEMCONTENT_NOT_STARTED...
     d                 c                   54
     d  XML_ERR_ELEMCONTENT_NOT_FINISHED...
     d                 c                   55
     d  XML_ERR_XMLDECL_NOT_STARTED...
     d                 c                   56
     d  XML_ERR_XMLDECL_NOT_FINISHED...
     d                 c                   57
     d  XML_ERR_CONDSEC_NOT_STARTED...
     d                 c                   58
     d  XML_ERR_CONDSEC_NOT_FINISHED...
     d                 c                   59
     d  XML_ERR_EXT_SUBSET_NOT_FINISHED...
     d                 c                   60
     d  XML_ERR_DOCTYPE_NOT_FINISHED...
     d                 c                   61
     d  XML_ERR_MISPLACED_CDATA_END...
     d                 c                   62
     d  XML_ERR_CDATA_NOT_FINISHED...
     d                 c                   63
     d  XML_ERR_RESERVED_XML_NAME...
     d                 c                   64
     d  XML_ERR_SPACE_REQUIRED...
     d                 c                   65
     d  XML_ERR_SEPARATOR_REQUIRED...
     d                 c                   66
     d  XML_ERR_NMTOKEN_REQUIRED...
     d                 c                   67
     d  XML_ERR_NAME_REQUIRED...
     d                 c                   68
     d  XML_ERR_PCDATA_REQUIRED...
     d                 c                   69
     d  XML_ERR_URI_REQUIRED...
     d                 c                   70
     d  XML_ERR_PUBID_REQUIRED...
     d                 c                   71
     d  XML_ERR_LT_REQUIRED...
     d                 c                   72
     d  XML_ERR_GT_REQUIRED...
     d                 c                   73
     d  XML_ERR_LTSLASH_REQUIRED...
     d                 c                   74
     d  XML_ERR_EQUAL_REQUIRED...
     d                 c                   75
     d  XML_ERR_TAG_NAME_MISMATCH...
     d                 c                   76
     d  XML_ERR_TAG_NOT_FINISHED...
     d                 c                   77
     d  XML_ERR_STANDALONE_VALUE...
     d                 c                   78
     d  XML_ERR_ENCODING_NAME...
     d                 c                   79
     d  XML_ERR_HYPHEN_IN_COMMENT...
     d                 c                   80
     d  XML_ERR_INVALID_ENCODING...
     d                 c                   81
     d  XML_ERR_EXT_ENTITY_STANDALONE...
     d                 c                   82
     d  XML_ERR_CONDSEC_INVALID...
     d                 c                   83
     d  XML_ERR_VALUE_REQUIRED...
     d                 c                   84
     d  XML_ERR_NOT_WELL_BALANCED...
     d                 c                   85
     d  XML_ERR_EXTRA_CONTENT...
     d                 c                   86
     d  XML_ERR_ENTITY_CHAR_ERROR...
     d                 c                   87
     d  XML_ERR_ENTITY_PE_INTERNAL...
     d                 c                   88
     d  XML_ERR_ENTITY_LOOP...
     d                 c                   89
     d  XML_ERR_ENTITY_BOUNDARY...
     d                 c                   90
     d  XML_ERR_INVALID_URI...
     d                 c                   91
     d  XML_ERR_URI_FRAGMENT...
     d                 c                   92
     d  XML_WAR_CATALOG_PI...
     d                 c                   93
     d  XML_ERR_NO_DTD...
     d                 c                   94
     d  XML_ERR_CONDSEC_INVALID_KEYWORD...
     d                 c                   95
     d  XML_ERR_VERSION_MISSING...
     d                 c                   96
     d  XML_WAR_UNKNOWN_VERSION...
     d                 c                   97
     d  XML_WAR_LANG_VALUE...
     d                 c                   98
     d  XML_WAR_NS_URI...
     d                 c                   99
     d  XML_WAR_NS_URI_RELATIVE...
     d                 c                   100
     d  XML_ERR_MISSING_ENCODING...
     d                 c                   101
     d  XML_WAR_SPACE_VALUE...
     d                 c                   102
     d  XML_ERR_NOT_STANDALONE...
     d                 c                   103
     d  XML_ERR_ENTITY_PROCESSING...
     d                 c                   104
     d  XML_ERR_NOTATION_PROCESSING...
     d                 c                   105
     d  XML_WAR_NS_COLUMN...
     d                 c                   106
     d  XML_WAR_ENTITY_REDEFINED...
     d                 c                   107
     d  XML_ERR_UNKNOWN_VERSION...
     d                 c                   108
     d  XML_ERR_VERSION_MISMATCH...
     d                 c                   109
     d  XML_ERR_NAME_TOO_LONG...
     d                 c                   110
     d  XML_ERR_USER_STOP...
     d                 c                   111
     d  XML_NS_ERR_XML_NAMESPACE...
     d                 c                   200
     d  XML_NS_ERR_UNDEFINED_NAMESPACE...
     d                 c                   201
     d  XML_NS_ERR_QNAME...
     d                 c                   202
     d  XML_NS_ERR_ATTRIBUTE_REDEFINED...
     d                 c                   203
     d  XML_NS_ERR_EMPTY...
     d                 c                   204
     d  XML_NS_ERR_COLON...
     d                 c                   205
     d  XML_DTD_ATTRIBUTE_DEFAULT...
     d                 c                   500
     d  XML_DTD_ATTRIBUTE_REDEFINED...
     d                 c                   501
     d  XML_DTD_ATTRIBUTE_VALUE...
     d                 c                   502
     d  XML_DTD_CONTENT_ERROR...
     d                 c                   503
     d  XML_DTD_CONTENT_MODEL...
     d                 c                   504
     d  XML_DTD_CONTENT_NOT_DETERMINIST...
     d                 c                   505
     d  XML_DTD_DIFFERENT_PREFIX...
     d                 c                   506
     d  XML_DTD_ELEM_DEFAULT_NAMESPACE...
     d                 c                   507
     d  XML_DTD_ELEM_NAMESPACE...
     d                 c                   508
     d  XML_DTD_ELEM_REDEFINED...
     d                 c                   509
     d  XML_DTD_EMPTY_NOTATION...
     d                 c                   510
     d  XML_DTD_ENTITY_TYPE...
     d                 c                   511
     d  XML_DTD_ID_FIXED...
     d                 c                   512
     d  XML_DTD_ID_REDEFINED...
     d                 c                   513
     d  XML_DTD_ID_SUBSET...
     d                 c                   514
     d  XML_DTD_INVALID_CHILD...
     d                 c                   515
     d  XML_DTD_INVALID_DEFAULT...
     d                 c                   516
     d  XML_DTD_LOAD_ERROR...
     d                 c                   517
     d  XML_DTD_MISSING_ATTRIBUTE...
     d                 c                   518
     d  XML_DTD_MIXED_CORRUPT...
     d                 c                   519
     d  XML_DTD_MULTIPLE_ID...
     d                 c                   520
     d  XML_DTD_NO_DOC...
     d                 c                   521
     d  XML_DTD_NO_DTD...
     d                 c                   522
     d  XML_DTD_NO_ELEM_NAME...
     d                 c                   523
     d  XML_DTD_NO_PREFIX...
     d                 c                   524
     d  XML_DTD_NO_ROOT...
     d                 c                   525
     d  XML_DTD_NOTATION_REDEFINED...
     d                 c                   526
     d  XML_DTD_NOTATION_VALUE...
     d                 c                   527
     d  XML_DTD_NOT_EMPTY...
     d                 c                   528
     d  XML_DTD_NOT_PCDATA...
     d                 c                   529
     d  XML_DTD_NOT_STANDALONE...
     d                 c                   530
     d  XML_DTD_ROOT_NAME...
     d                 c                   531
     d  XML_DTD_STANDALONE_WHITE_SPACE...
     d                 c                   532
     d  XML_DTD_UNKNOWN_ATTRIBUTE...
     d                 c                   533
     d  XML_DTD_UNKNOWN_ELEM...
     d                 c                   534
     d  XML_DTD_UNKNOWN_ENTITY...
     d                 c                   535
     d  XML_DTD_UNKNOWN_ID...
     d                 c                   536
     d  XML_DTD_UNKNOWN_NOTATION...
     d                 c                   537
     d  XML_DTD_STANDALONE_DEFAULTED...
     d                 c                   538
     d  XML_DTD_XMLID_VALUE...
     d                 c                   539
     d  XML_DTD_XMLID_TYPE...
     d                 c                   540
     d  XML_DTD_DUP_TOKEN...
     d                 c                   541
     d  XML_HTML_STRUCURE_ERROR...
     d                 c                   800
     d  XML_HTML_UNKNOWN_TAG...
     d                 c                   801
     d  XML_RNGP_ANYNAME_ATTR_ANCESTOR...
     d                 c                   1000
     d  XML_RNGP_ATTR_CONFLICT...
     d                 c                   1001
     d  XML_RNGP_ATTRIBUTE_CHILDREN...
     d                 c                   1002
     d  XML_RNGP_ATTRIBUTE_CONTENT...
     d                 c                   1003
     d  XML_RNGP_ATTRIBUTE_EMPTY...
     d                 c                   1004
     d  XML_RNGP_ATTRIBUTE_NOOP...
     d                 c                   1005
     d  XML_RNGP_CHOICE_CONTENT...
     d                 c                   1006
     d  XML_RNGP_CHOICE_EMPTY...
     d                 c                   1007
     d  XML_RNGP_CREATE_FAILURE...
     d                 c                   1008
     d  XML_RNGP_DATA_CONTENT...
     d                 c                   1009
     d  XML_RNGP_DEF_CHOICE_AND_INTERLEAVE...
     d                 c                   1010
     d  XML_RNGP_DEFINE_CREATE_FAILED...
     d                 c                   1011
     d  XML_RNGP_DEFINE_EMPTY...
     d                 c                   1012
     d  XML_RNGP_DEFINE_MISSING...
     d                 c                   1013
     d  XML_RNGP_DEFINE_NAME_MISSING...
     d                 c                   1014
     d  XML_RNGP_ELEM_CONTENT_EMPTY...
     d                 c                   1015
     d  XML_RNGP_ELEM_CONTENT_ERROR...
     d                 c                   1016
     d  XML_RNGP_ELEMENT_EMPTY...
     d                 c                   1017
     d  XML_RNGP_ELEMENT_CONTENT...
     d                 c                   1018
     d  XML_RNGP_ELEMENT_NAME...
     d                 c                   1019
     d  XML_RNGP_ELEMENT_NO_CONTENT...
     d                 c                   1020
     d  XML_RNGP_ELEM_TEXT_CONFLICT...
     d                 c                   1021
     d  XML_RNGP_EMPTY...
     d                 c                   1022
     d  XML_RNGP_EMPTY_CONSTRUCT...
     d                 c                   1023
     d  XML_RNGP_EMPTY_CONTENT...
     d                 c                   1024
     d  XML_RNGP_EMPTY_NOT_EMPTY...
     d                 c                   1025
     d  XML_RNGP_ERROR_TYPE_LIB...
     d                 c                   1026
     d  XML_RNGP_EXCEPT_EMPTY...
     d                 c                   1027
     d  XML_RNGP_EXCEPT_MISSING...
     d                 c                   1028
     d  XML_RNGP_EXCEPT_MULTIPLE...
     d                 c                   1029
     d  XML_RNGP_EXCEPT_NO_CONTENT...
     d                 c                   1030
     d  XML_RNGP_EXTERNALREF_EMTPY...
     d                 c                   1031
     d  XML_RNGP_EXTERNAL_REF_FAILURE...
     d                 c                   1032
     d  XML_RNGP_EXTERNALREF_RECURSE...
     d                 c                   1033
     d  XML_RNGP_FORBIDDEN_ATTRIBUTE...
     d                 c                   1034
     d  XML_RNGP_FOREIGN_ELEMENT...
     d                 c                   1035
     d  XML_RNGP_GRAMMAR_CONTENT...
     d                 c                   1036
     d  XML_RNGP_GRAMMAR_EMPTY...
     d                 c                   1037
     d  XML_RNGP_GRAMMAR_MISSING...
     d                 c                   1038
     d  XML_RNGP_GRAMMAR_NO_START...
     d                 c                   1039
     d  XML_RNGP_GROUP_ATTR_CONFLICT...
     d                 c                   1040
     d  XML_RNGP_HREF_ERROR...
     d                 c                   1041
     d  XML_RNGP_INCLUDE_EMPTY...
     d                 c                   1042
     d  XML_RNGP_INCLUDE_FAILURE...
     d                 c                   1043
     d  XML_RNGP_INCLUDE_RECURSE...
     d                 c                   1044
     d  XML_RNGP_INTERLEAVE_ADD...
     d                 c                   1045
     d  XML_RNGP_INTERLEAVE_CREATE_FAILED...
     d                 c                   1046
     d  XML_RNGP_INTERLEAVE_EMPTY...
     d                 c                   1047
     d  XML_RNGP_INTERLEAVE_NO_CONTENT...
     d                 c                   1048
     d  XML_RNGP_INVALID_DEFINE_NAME...
     d                 c                   1049
     d  XML_RNGP_INVALID_URI...
     d                 c                   1050
     d  XML_RNGP_INVALID_VALUE...
     d                 c                   1051
     d  XML_RNGP_MISSING_HREF...
     d                 c                   1052
     d  XML_RNGP_NAME_MISSING...
     d                 c                   1053
     d  XML_RNGP_NEED_COMBINE...
     d                 c                   1054
     d  XML_RNGP_NOTALLOWED_NOT_EMPTY...
     d                 c                   1055
     d  XML_RNGP_NSNAME_ATTR_ANCESTOR...
     d                 c                   1056
     d  XML_RNGP_NSNAME_NO_NS...
     d                 c                   1057
     d  XML_RNGP_PARAM_FORBIDDEN...
     d                 c                   1058
     d  XML_RNGP_PARAM_NAME_MISSING...
     d                 c                   1059
     d  XML_RNGP_PARENTREF_CREATE_FAILED...
     d                 c                   1060
     d  XML_RNGP_PARENTREF_NAME_INVALID...
     d                 c                   1061
     d  XML_RNGP_PARENTREF_NO_NAME...
     d                 c                   1062
     d  XML_RNGP_PARENTREF_NO_PARENT...
     d                 c                   1063
     d  XML_RNGP_PARENTREF_NOT_EMPTY...
     d                 c                   1064
     d  XML_RNGP_PARSE_ERROR...
     d                 c                   1065
     d  XML_RNGP_PAT_ANYNAME_EXCEPT_ANYNAME...
     d                 c                   1066
     d  XML_RNGP_PAT_ATTR_ATTR...
     d                 c                   1067
     d  XML_RNGP_PAT_ATTR_ELEM...
     d                 c                   1068
     d  XML_RNGP_PAT_DATA_EXCEPT_ATTR...
     d                 c                   1069
     d  XML_RNGP_PAT_DATA_EXCEPT_ELEM...
     d                 c                   1070
     d  XML_RNGP_PAT_DATA_EXCEPT_EMPTY...
     d                 c                   1071
     d  XML_RNGP_PAT_DATA_EXCEPT_GROUP...
     d                 c                   1072
     d  XML_RNGP_PAT_DATA_EXCEPT_INTERLEAVE...
     d                 c                   1073
     d  XML_RNGP_PAT_DATA_EXCEPT_LIST...
     d                 c                   1074
     d  XML_RNGP_PAT_DATA_EXCEPT_ONEMORE...
     d                 c                   1075
     d  XML_RNGP_PAT_DATA_EXCEPT_REF...
     d                 c                   1076
     d  XML_RNGP_PAT_DATA_EXCEPT_TEXT...
     d                 c                   1077
     d  XML_RNGP_PAT_LIST_ATTR...
     d                 c                   1078
     d  XML_RNGP_PAT_LIST_ELEM...
     d                 c                   1079
     d  XML_RNGP_PAT_LIST_INTERLEAVE...
     d                 c                   1080
     d  XML_RNGP_PAT_LIST_LIST...
     d                 c                   1081
     d  XML_RNGP_PAT_LIST_REF...
     d                 c                   1082
     d  XML_RNGP_PAT_LIST_TEXT...
     d                 c                   1083
     d  XML_RNGP_PAT_NSNAME_EXCEPT_ANYNAME...
     d                 c                   1084
     d  XML_RNGP_PAT_NSNAME_EXCEPT_NSNAME...
     d                 c                   1085
     d  XML_RNGP_PAT_ONEMORE_GROUP_ATTR...
     d                 c                   1086
     d  XML_RNGP_PAT_ONEMORE_INTERLEAVE_ATTR...
     d                 c                   1087
     d  XML_RNGP_PAT_START_ATTR...
     d                 c                   1088
     d  XML_RNGP_PAT_START_DATA...
     d                 c                   1089
     d  XML_RNGP_PAT_START_EMPTY...
     d                 c                   1090
     d  XML_RNGP_PAT_START_GROUP...
     d                 c                   1091
     d  XML_RNGP_PAT_START_INTERLEAVE...
     d                 c                   1092
     d  XML_RNGP_PAT_START_LIST...
     d                 c                   1093
     d  XML_RNGP_PAT_START_ONEMORE...
     d                 c                   1094
     d  XML_RNGP_PAT_START_TEXT...
     d                 c                   1095
     d  XML_RNGP_PAT_START_VALUE...
     d                 c                   1096
     d  XML_RNGP_PREFIX_UNDEFINED...
     d                 c                   1097
     d  XML_RNGP_REF_CREATE_FAILED...
     d                 c                   1098
     d  XML_RNGP_REF_CYCLE...
     d                 c                   1099
     d  XML_RNGP_REF_NAME_INVALID...
     d                 c                   1100
     d  XML_RNGP_REF_NO_DEF...
     d                 c                   1101
     d  XML_RNGP_REF_NO_NAME...
     d                 c                   1102
     d  XML_RNGP_REF_NOT_EMPTY...
     d                 c                   1103
     d  XML_RNGP_START_CHOICE_AND_INTERLEAVE...
     d                 c                   1104
     d  XML_RNGP_START_CONTENT...
     d                 c                   1105
     d  XML_RNGP_START_EMPTY...
     d                 c                   1106
     d  XML_RNGP_START_MISSING...
     d                 c                   1107
     d  XML_RNGP_TEXT_EXPECTED...
     d                 c                   1108
     d  XML_RNGP_TEXT_HAS_CHILD...
     d                 c                   1109
     d  XML_RNGP_TYPE_MISSING...
     d                 c                   1110
     d  XML_RNGP_TYPE_NOT_FOUND...
     d                 c                   1111
     d  XML_RNGP_TYPE_VALUE...
     d                 c                   1112
     d  XML_RNGP_UNKNOWN_ATTRIBUTE...
     d                 c                   1113
     d  XML_RNGP_UNKNOWN_COMBINE...
     d                 c                   1114
     d  XML_RNGP_UNKNOWN_CONSTRUCT...
     d                 c                   1115
     d  XML_RNGP_UNKNOWN_TYPE_LIB...
     d                 c                   1116
     d  XML_RNGP_URI_FRAGMENT...
     d                 c                   1117
     d  XML_RNGP_URI_NOT_ABSOLUTE...
     d                 c                   1118
     d  XML_RNGP_VALUE_EMPTY...
     d                 c                   1119
     d  XML_RNGP_VALUE_NO_CONTENT...
     d                 c                   1120
     d  XML_RNGP_XMLNS_NAME...
     d                 c                   1121
     d  XML_RNGP_XML_NS...
     d                 c                   1122
     d  XML_XPATH_EXPRESSION_OK...
     d                 c                   1200
     d  XML_XPATH_NUMBER_ERROR...
     d                 c                   1201
     d  XML_XPATH_UNFINISHED_LITERAL_ERROR...
     d                 c                   1202
     d  XML_XPATH_START_LITERAL_ERROR...
     d                 c                   1203
     d  XML_XPATH_VARIABLE_REF_ERROR...
     d                 c                   1204
     d  XML_XPATH_UNDEF_VARIABLE_ERROR...
     d                 c                   1205
     d  XML_XPATH_INVALID_PREDICATE_ERROR...
     d                 c                   1206
     d  XML_XPATH_EXPR_ERROR...
     d                 c                   1207
     d  XML_XPATH_UNCLOSED_ERROR...
     d                 c                   1208
     d  XML_XPATH_UNKNOWN_FUNC_ERROR...
     d                 c                   1209
     d  XML_XPATH_INVALID_OPERAND...
     d                 c                   1210
     d  XML_XPATH_INVALID_TYPE...
     d                 c                   1211
     d  XML_XPATH_INVALID_ARITY...
     d                 c                   1212
     d  XML_XPATH_INVALID_CTXT_SIZE...
     d                 c                   1213
     d  XML_XPATH_INVALID_CTXT_POSITION...
     d                 c                   1214
     d  XML_XPATH_MEMORY_ERROR...
     d                 c                   1215
     d  XML_XPTR_SYNTAX_ERROR...
     d                 c                   1216
     d  XML_XPTR_RESOURCE_ERROR...
     d                 c                   1217
     d  XML_XPTR_SUB_RESOURCE_ERROR...
     d                 c                   1218
     d  XML_XPATH_UNDEF_PREFIX_ERROR...
     d                 c                   1219
     d  XML_XPATH_ENCODING_ERROR...
     d                 c                   1220
     d  XML_XPATH_INVALID_CHAR_ERROR...
     d                 c                   1231
     d  XML_TREE_INVALID_HEX...
     d                 c                   1300
     d  XML_TREE_INVALID_DEC...
     d                 c                   1301
     d  XML_TREE_UNTERMINATED_ENTITY...
     d                 c                   1302
     d  XML_TREE_NOT_UTF8...
     d                 c                   1303
     d  XML_SAVE_NOT_UTF8...
     d                 c                   1400
     d  XML_SAVE_CHAR_INVALID...
     d                 c                   1401
     d  XML_SAVE_NO_DOCTYPE...
     d                 c                   1402
     d  XML_SAVE_UNKNOWN_ENCODING...
     d                 c                   1403
     d  XML_REGEXP_COMPILE_ERROR...
     d                 c                   1403
     d  XML_IO_UNKNOWN...
     d                 c                   1500
     d  XML_IO_EACCES  c                   1501
     d  XML_IO_EAGAIN  c                   1502
     d  XML_IO_EBADF   c                   1503
     d  XML_IO_EBADMSG...
     d                 c                   1504
     d  XML_IO_EBUSY   c                   1505
     d  XML_IO_ECANCELED...
     d                 c                   1506
     d  XML_IO_ECHILD  c                   1507
     d  XML_IO_EDEADLK...
     d                 c                   1508
     d  XML_IO_EDOM    c                   1509
     d  XML_IO_EEXIST  c                   1510
     d  XML_IO_EFAULT  c                   1511
     d  XML_IO_EFBIG   c                   1512
     d  XML_IO_EINPROGRESS...
     d                 c                   1513
     d  XML_IO_EINTR   c                   1514
     d  XML_IO_EINVAL  c                   1515
     d  XML_IO_EIO     c                   1516
     d  XML_IO_EISDIR  c                   1517
     d  XML_IO_EMFILE  c                   1518
     d  XML_IO_EMLINK  c                   1519
     d  XML_IO_EMSGSIZE...
     d                 c                   1520
     d  XML_IO_ENAMETOOLONG...
     d                 c                   1521
     d  XML_IO_ENFILE  c                   1522
     d  XML_IO_ENODEV  c                   1523
     d  XML_IO_ENOENT  c                   1524
     d  XML_IO_ENOEXEC...
     d                 c                   1525
     d  XML_IO_ENOLCK  c                   1526
     d  XML_IO_ENOMEM  c                   1527
     d  XML_IO_ENOSPC  c                   1528
     d  XML_IO_ENOSYS  c                   1529
     d  XML_IO_ENOTDIR...
     d                 c                   1530
     d  XML_IO_ENOTEMPTY...
     d                 c                   1531
     d  XML_IO_ENOTSUP...
     d                 c                   1532
     d  XML_IO_ENOTTY  c                   1533
     d  XML_IO_ENXIO   c                   1534
     d  XML_IO_EPERM   c                   1535
     d  XML_IO_EPIPE   c                   1536
     d  XML_IO_ERANGE  c                   1537
     d  XML_IO_EROFS   c                   1538
     d  XML_IO_ESPIPE  c                   1539
     d  XML_IO_ESRCH   c                   1540
     d  XML_IO_ETIMEDOUT...
     d                 c                   1541
     d  XML_IO_EXDEV   c                   1542
     d  XML_IO_NETWORK_ATTEMPT...
     d                 c                   1543
     d  XML_IO_ENCODER...
     d                 c                   1544
     d  XML_IO_FLUSH   c                   1545
     d  XML_IO_WRITE   c                   1546
     d  XML_IO_NO_INPUT...
     d                 c                   1547
     d  XML_IO_BUFFER_FULL...
     d                 c                   1548
     d  XML_IO_LOAD_ERROR...
     d                 c                   1549
     d  XML_IO_ENOTSOCK...
     d                 c                   1550
     d  XML_IO_EISCONN...
     d                 c                   1551
     d  XML_IO_ECONNREFUSED...
     d                 c                   1552
     d  XML_IO_ENETUNREACH...
     d                 c                   1553
     d  XML_IO_EADDRINUSE...
     d                 c                   1554
     d  XML_IO_EALREADY...
     d                 c                   1555
     d  XML_IO_EAFNOSUPPORT...
     d                 c                   1556
     d  XML_XINCLUDE_RECURSION...
     d                 c                   1600
     d  XML_XINCLUDE_PARSE_VALUE...
     d                 c                   1601
     d  XML_XINCLUDE_ENTITY_DEF_MISMATCH...
     d                 c                   1602
     d  XML_XINCLUDE_NO_HREF...
     d                 c                   1603
     d  XML_XINCLUDE_NO_FALLBACK...
     d                 c                   1604
     d  XML_XINCLUDE_HREF_URI...
     d                 c                   1605
     d  XML_XINCLUDE_TEXT_FRAGMENT...
     d                 c                   1606
     d  XML_XINCLUDE_TEXT_DOCUMENT...
     d                 c                   1607
     d  XML_XINCLUDE_INVALID_CHAR...
     d                 c                   1608
     d  XML_XINCLUDE_BUILD_FAILED...
     d                 c                   1609
     d  XML_XINCLUDE_UNKNOWN_ENCODING...
     d                 c                   1610
     d  XML_XINCLUDE_MULTIPLE_ROOT...
     d                 c                   1611
     d  XML_XINCLUDE_XPTR_FAILED...
     d                 c                   1612
     d  XML_XINCLUDE_XPTR_RESULT...
     d                 c                   1613
     d  XML_XINCLUDE_INCLUDE_IN_INCLUDE...
     d                 c                   1614
     d  XML_XINCLUDE_FALLBACKS_IN_INCLUDE...
     d                 c                   1615
     d  XML_XINCLUDE_FALLBACK_NOT_IN_INCLUDE...
     d                 c                   1616
     d  XML_XINCLUDE_DEPRECATED_NS...
     d                 c                   1617
     d  XML_XINCLUDE_FRAGMENT_ID...
     d                 c                   1618
     d  XML_CATALOG_MISSING_ATTR...
     d                 c                   1650
     d  XML_CATALOG_ENTRY_BROKEN...
     d                 c                   1651
     d  XML_CATALOG_PREFER_VALUE...
     d                 c                   1652
     d  XML_CATALOG_NOT_CATALOG...
     d                 c                   1653
     d  XML_CATALOG_RECURSION...
     d                 c                   1654
     d  XML_SCHEMAP_PREFIX_UNDEFINED...
     d                 c                   1700
     d  XML_SCHEMAP_ATTRFORMDEFAULT_VALUE...
     d                 c                   1701
     d  XML_SCHEMAP_ATTRGRP_NONAME_NOREF...
     d                 c                   1702
     d  XML_SCHEMAP_ATTR_NONAME_NOREF...
     d                 c                   1703
     d  XML_SCHEMAP_COMPLEXTYPE_NONAME_NOREF...
     d                 c                   1704
     d  XML_SCHEMAP_ELEMFORMDEFAULT_VALUE...
     d                 c                   1705
     d  XML_SCHEMAP_ELEM_NONAME_NOREF...
     d                 c                   1706
     d  XML_SCHEMAP_EXTENSION_NO_BASE...
     d                 c                   1707
     d  XML_SCHEMAP_FACET_NO_VALUE...
     d                 c                   1708
     d  XML_SCHEMAP_FAILED_BUILD_IMPORT...
     d                 c                   1709
     d  XML_SCHEMAP_GROUP_NONAME_NOREF...
     d                 c                   1710
     d  XML_SCHEMAP_IMPORT_NAMESPACE_NOT_URI...
     d                 c                   1711
     d  XML_SCHEMAP_IMPORT_REDEFINE_NSNAME...
     d                 c                   1712
     d  XML_SCHEMAP_IMPORT_SCHEMA_NOT_URI...
     d                 c                   1713
     d  XML_SCHEMAP_INVALID_BOOLEAN...
     d                 c                   1714
     d  XML_SCHEMAP_INVALID_ENUM...
     d                 c                   1715
     d  XML_SCHEMAP_INVALID_FACET...
     d                 c                   1716
     d  XML_SCHEMAP_INVALID_FACET_VALUE...
     d                 c                   1717
     d  XML_SCHEMAP_INVALID_MAXOCCURS...
     d                 c                   1718
     d  XML_SCHEMAP_INVALID_MINOCCURS...
     d                 c                   1719
     d  XML_SCHEMAP_INVALID_REF_AND_SUBTYPE...
     d                 c                   1720
     d  XML_SCHEMAP_INVALID_WHITE_SPACE...
     d                 c                   1721
     d  XML_SCHEMAP_NOATTR_NOREF...
     d                 c                   1722
     d  XML_SCHEMAP_NOTATION_NO_NAME...
     d                 c                   1723
     d  XML_SCHEMAP_NOTYPE_NOREF...
     d                 c                   1724
     d  XML_SCHEMAP_REF_AND_SUBTYPE...
     d                 c                   1725
     d  XML_SCHEMAP_RESTRICTION_NONAME_NOREF...
     d                 c                   1726
     d  XML_SCHEMAP_SIMPLETYPE_NONAME...
     d                 c                   1727
     d  XML_SCHEMAP_TYPE_AND_SUBTYPE...
     d                 c                   1728
     d  XML_SCHEMAP_UNKNOWN_ALL_CHILD...
     d                 c                   1729
     d  XML_SCHEMAP_UNKNOWN_ANYATTRIBUTE_CHILD...
     d                 c                   1730
     d  XML_SCHEMAP_UNKNOWN_ATTR_CHILD...
     d                 c                   1731
     d  XML_SCHEMAP_UNKNOWN_ATTRGRP_CHILD...
     d                 c                   1732
     d  XML_SCHEMAP_UNKNOWN_ATTRIBUTE_GROUP...
     d                 c                   1733
     d  XML_SCHEMAP_UNKNOWN_BASE_TYPE...
     d                 c                   1734
     d  XML_SCHEMAP_UNKNOWN_CHOICE_CHILD...
     d                 c                   1735
     d  XML_SCHEMAP_UNKNOWN_COMPLEXCONTENT_CHILD...
     d                 c                   1736
     d  XML_SCHEMAP_UNKNOWN_COMPLEXTYPE_CHILD...
     d                 c                   1737
     d  XML_SCHEMAP_UNKNOWN_ELEM_CHILD...
     d                 c                   1738
     d  XML_SCHEMAP_UNKNOWN_EXTENSION_CHILD...
     d                 c                   1739
     d  XML_SCHEMAP_UNKNOWN_FACET_CHILD...
     d                 c                   1740
     d  XML_SCHEMAP_UNKNOWN_FACET_TYPE...
     d                 c                   1741
     d  XML_SCHEMAP_UNKNOWN_GROUP_CHILD...
     d                 c                   1742
     d  XML_SCHEMAP_UNKNOWN_IMPORT_CHILD...
     d                 c                   1743
     d  XML_SCHEMAP_UNKNOWN_LIST_CHILD...
     d                 c                   1744
     d  XML_SCHEMAP_UNKNOWN_NOTATION_CHILD...
     d                 c                   1745
     d  XML_SCHEMAP_UNKNOWN_PROCESSCONTENT_CHILD...
     d                 c                   1746
     d  XML_SCHEMAP_UNKNOWN_REF...
     d                 c                   1747
     d  XML_SCHEMAP_UNKNOWN_RESTRICTION_CHILD...
     d                 c                   1748
     d  XML_SCHEMAP_UNKNOWN_SCHEMAS_CHILD...
     d                 c                   1749
     d  XML_SCHEMAP_UNKNOWN_SEQUENCE_CHILD...
     d                 c                   1750
     d  XML_SCHEMAP_UNKNOWN_SIMPLECONTENT_CHILD...
     d                 c                   1751
     d  XML_SCHEMAP_UNKNOWN_SIMPLETYPE_CHILD...
     d                 c                   1752
     d  XML_SCHEMAP_UNKNOWN_TYPE...
     d                 c                   1753
     d  XML_SCHEMAP_UNKNOWN_UNION_CHILD...
     d                 c                   1754
     d  XML_SCHEMAP_ELEM_DEFAULT_FIXED...
     d                 c                   1755
     d  XML_SCHEMAP_REGEXP_INVALID...
     d                 c                   1756
     d  XML_SCHEMAP_FAILED_LOAD...
     d                 c                   1757
     d  XML_SCHEMAP_NOTHING_TO_PARSE...
     d                 c                   1758
     d  XML_SCHEMAP_NOROOT...
     d                 c                   1759
     d  XML_SCHEMAP_REDEFINED_GROUP...
     d                 c                   1760
     d  XML_SCHEMAP_REDEFINED_TYPE...
     d                 c                   1761
     d  XML_SCHEMAP_REDEFINED_ELEMENT...
     d                 c                   1762
     d  XML_SCHEMAP_REDEFINED_ATTRGROUP...
     d                 c                   1763
     d  XML_SCHEMAP_REDEFINED_ATTR...
     d                 c                   1764
     d  XML_SCHEMAP_REDEFINED_NOTATION...
     d                 c                   1765
     d  XML_SCHEMAP_FAILED_PARSE...
     d                 c                   1766
     d  XML_SCHEMAP_UNKNOWN_PREFIX...
     d                 c                   1767
     d  XML_SCHEMAP_DEF_AND_PREFIX...
     d                 c                   1768
     d  XML_SCHEMAP_UNKNOWN_INCLUDE_CHILD...
     d                 c                   1769
     d  XML_SCHEMAP_INCLUDE_SCHEMA_NOT_URI...
     d                 c                   1770
     d  XML_SCHEMAP_INCLUDE_SCHEMA_NO_URI...
     d                 c                   1771
     d  XML_SCHEMAP_NOT_SCHEMA...
     d                 c                   1772
     d  XML_SCHEMAP_UNKNOWN_MEMBER_TYPE...
     d                 c                   1773
     d  XML_SCHEMAP_INVALID_ATTR_USE...
     d                 c                   1774
     d  XML_SCHEMAP_RECURSIVE...
     d                 c                   1775
     d  XML_SCHEMAP_SUPERNUMEROUS_LIST_ITEM_TYPE...
     d                 c                   1776
     d  XML_SCHEMAP_INVALID_ATTR_COMBINATION...
     d                 c                   1777
     d  XML_SCHEMAP_INVALID_ATTR_INLINE_COMBINATION...
     d                 c                   1778
     d  XML_SCHEMAP_MISSING_SIMPLETYPE_CHILD...
     d                 c                   1779
     d  XML_SCHEMAP_INVALID_ATTR_NAME...
     d                 c                   1780
     d  XML_SCHEMAP_REF_AND_CONTENT...
     d                 c                   1781
     d  XML_SCHEMAP_CT_PROPS_CORRECT_1...
     d                 c                   1782
     d  XML_SCHEMAP_CT_PROPS_CORRECT_2...
     d                 c                   1783
     d  XML_SCHEMAP_CT_PROPS_CORRECT_3...
     d                 c                   1784
     d  XML_SCHEMAP_CT_PROPS_CORRECT_4...
     d                 c                   1785
     d  XML_SCHEMAP_CT_PROPS_CORRECT_5...
     d                 c                   1786
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_1...
     d                 c                   1787
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_1_1...
     d                 c                   1788
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_1_2...
     d                 c                   1789
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_2...
     d                 c                   1790
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_3...
     d                 c                   1791
     d  XML_SCHEMAP_WILDCARD_INVALID_NS_MEMBER...
     d                 c                   1792
     d  XML_SCHEMAP_INTERSECTION_NOT_EXPRESSIBLE...
     d                 c                   1793
     d  XML_SCHEMAP_UNION_NOT_EXPRESSIBLE...
     d                 c                   1794
     d  XML_SCHEMAP_SRC_IMPORT_3_1...
     d                 c                   1795
     d  XML_SCHEMAP_SRC_IMPORT_3_2...
     d                 c                   1796
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_4_1...
     d                 c                   1797
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_4_2...
     d                 c                   1798
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_4_3...
     d                 c                   1799
     d  XML_SCHEMAP_COS_CT_EXTENDS_1_3...
     d                 c                   1800
     d  XML_SCHEMAV_NOROOT...
     d                 c                   1801
     d  XML_SCHEMAV_UNDECLAREDELEM...
     d                 c                   1802
     d  XML_SCHEMAV_NOTTOPLEVEL...
     d                 c                   1803
     d  XML_SCHEMAV_MISSING...
     d                 c                   1804
     d  XML_SCHEMAV_WRONGELEM...
     d                 c                   1805
     d  XML_SCHEMAV_NOTYPE...
     d                 c                   1806
     d  XML_SCHEMAV_NOROLLBACK...
     d                 c                   1807
     d  XML_SCHEMAV_ISABSTRACT...
     d                 c                   1808
     d  XML_SCHEMAV_NOTEMPTY...
     d                 c                   1809
     d  XML_SCHEMAV_ELEMCONT...
     d                 c                   1810
     d  XML_SCHEMAV_HAVEDEFAULT...
     d                 c                   1811
     d  XML_SCHEMAV_NOTNILLABLE...
     d                 c                   1812
     d  XML_SCHEMAV_EXTRACONTENT...
     d                 c                   1813
     d  XML_SCHEMAV_INVALIDATTR...
     d                 c                   1814
     d  XML_SCHEMAV_INVALIDELEM...
     d                 c                   1815
     d  XML_SCHEMAV_NOTDETERMINIST...
     d                 c                   1816
     d  XML_SCHEMAV_CONSTRUCT...
     d                 c                   1817
     d  XML_SCHEMAV_INTERNAL...
     d                 c                   1818
     d  XML_SCHEMAV_NOTSIMPLE...
     d                 c                   1819
     d  XML_SCHEMAV_ATTRUNKNOWN...
     d                 c                   1820
     d  XML_SCHEMAV_ATTRINVALID...
     d                 c                   1821
     d  XML_SCHEMAV_VALUE...
     d                 c                   1822
     d  XML_SCHEMAV_FACET...
     d                 c                   1823
     d  XML_SCHEMAV_CVC_DATATYPE_VALID_1_2_1...
     d                 c                   1824
     d  XML_SCHEMAV_CVC_DATATYPE_VALID_1_2_2...
     d                 c                   1825
     d  XML_SCHEMAV_CVC_DATATYPE_VALID_1_2_3...
     d                 c                   1826
     d  XML_SCHEMAV_CVC_TYPE_3_1_1...
     d                 c                   1827
     d  XML_SCHEMAV_CVC_TYPE_3_1_2...
     d                 c                   1828
     d  XML_SCHEMAV_CVC_FACET_VALID...
     d                 c                   1829
     d  XML_SCHEMAV_CVC_LENGTH_VALID...
     d                 c                   1830
     d  XML_SCHEMAV_CVC_MINLENGTH_VALID...
     d                 c                   1831
     d  XML_SCHEMAV_CVC_MAXLENGTH_VALID...
     d                 c                   1832
     d  XML_SCHEMAV_CVC_MININCLUSIVE_VALID...
     d                 c                   1833
     d  XML_SCHEMAV_CVC_MAXINCLUSIVE_VALID...
     d                 c                   1834
     d  XML_SCHEMAV_CVC_MINEXCLUSIVE_VALID...
     d                 c                   1835
     d  XML_SCHEMAV_CVC_MAXEXCLUSIVE_VALID...
     d                 c                   1836
     d  XML_SCHEMAV_CVC_TOTALDIGITS_VALID...
     d                 c                   1837
     d  XML_SCHEMAV_CVC_FRACTIONDIGITS_VALID...
     d                 c                   1838
     d  XML_SCHEMAV_CVC_PATTERN_VALID...
     d                 c                   1839
     d  XML_SCHEMAV_CVC_ENUMERATION_VALID...
     d                 c                   1840
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_2_1...
     d                 c                   1841
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_2_2...
     d                 c                   1842
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_2_3...
     d                 c                   1843
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_2_4...
     d                 c                   1844
     d  XML_SCHEMAV_CVC_ELT_1...
     d                 c                   1845
     d  XML_SCHEMAV_CVC_ELT_2...
     d                 c                   1846
     d  XML_SCHEMAV_CVC_ELT_3_1...
     d                 c                   1847
     d  XML_SCHEMAV_CVC_ELT_3_2_1...
     d                 c                   1848
     d  XML_SCHEMAV_CVC_ELT_3_2_2...
     d                 c                   1849
     d  XML_SCHEMAV_CVC_ELT_4_1...
     d                 c                   1850
     d  XML_SCHEMAV_CVC_ELT_4_2...
     d                 c                   1851
     d  XML_SCHEMAV_CVC_ELT_4_3...
     d                 c                   1852
     d  XML_SCHEMAV_CVC_ELT_5_1_1...
     d                 c                   1853
     d  XML_SCHEMAV_CVC_ELT_5_1_2...
     d                 c                   1854
     d  XML_SCHEMAV_CVC_ELT_5_2_1...
     d                 c                   1855
     d  XML_SCHEMAV_CVC_ELT_5_2_2_1...
     d                 c                   1856
     d  XML_SCHEMAV_CVC_ELT_5_2_2_2_1...
     d                 c                   1857
     d  XML_SCHEMAV_CVC_ELT_5_2_2_2_2...
     d                 c                   1858
     d  XML_SCHEMAV_CVC_ELT_6...
     d                 c                   1859
     d  XML_SCHEMAV_CVC_ELT_7...
     d                 c                   1860
     d  XML_SCHEMAV_CVC_ATTRIBUTE_1...
     d                 c                   1861
     d  XML_SCHEMAV_CVC_ATTRIBUTE_2...
     d                 c                   1862
     d  XML_SCHEMAV_CVC_ATTRIBUTE_3...
     d                 c                   1863
     d  XML_SCHEMAV_CVC_ATTRIBUTE_4...
     d                 c                   1864
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_3_1...
     d                 c                   1865
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_3_2_1...
     d                 c                   1866
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_3_2_2...
     d                 c                   1867
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_4...
     d                 c                   1868
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_5_1...
     d                 c                   1869
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_5_2...
     d                 c                   1870
     d  XML_SCHEMAV_ELEMENT_CONTENT...
     d                 c                   1871
     d  XML_SCHEMAV_DOCUMENT_ELEMENT_MISSING...
     d                 c                   1872
     d  XML_SCHEMAV_CVC_COMPLEX_TYPE_1...
     d                 c                   1873
     d  XML_SCHEMAV_CVC_AU...
     d                 c                   1874
     d  XML_SCHEMAV_CVC_TYPE_1...
     d                 c                   1875
     d  XML_SCHEMAV_CVC_TYPE_2...
     d                 c                   1876
     d  XML_SCHEMAV_CVC_IDC...
     d                 c                   1877
     d  XML_SCHEMAV_CVC_WILDCARD...
     d                 c                   1878
     d  XML_SCHEMAV_MISC...
     d                 c                   1879
     d  XML_XPTR_UNKNOWN_SCHEME...
     d                 c                   1900
     d  XML_XPTR_CHILDSEQ_START...
     d                 c                   1901
     d  XML_XPTR_EVAL_FAILED...
     d                 c                   1902
     d  XML_XPTR_EXTRA_OBJECTS...
     d                 c                   1903
     d  XML_C14N_CREATE_CTXT...
     d                 c                   1950
     d  XML_C14N_REQUIRES_UTF8...
     d                 c                   1951
     d  XML_C14N_CREATE_STACK...
     d                 c                   1952
     d  XML_C14N_INVALID_NODE...
     d                 c                   1953
     d  XML_C14N_UNKNOW_NODE...
     d                 c                   1954
     d  XML_C14N_RELATIVE_NAMESPACE...
     d                 c                   1955
     d  XML_FTP_PASV_ANSWER...
     d                 c                   2000
     d  XML_FTP_EPSV_ANSWER...
     d                 c                   2001
     d  XML_FTP_ACCNT...
     d                 c                   2002
     d  XML_FTP_URL_SYNTAX...
     d                 c                   2003
     d  XML_HTTP_URL_SYNTAX...
     d                 c                   2020
     d  XML_HTTP_USE_IP...
     d                 c                   2021
     d  XML_HTTP_UNKNOWN_HOST...
     d                 c                   2022
     d  XML_SCHEMAP_SRC_SIMPLE_TYPE_1...
     d                 c                   3000
     d  XML_SCHEMAP_SRC_SIMPLE_TYPE_2...
     d                 c                   3001
     d  XML_SCHEMAP_SRC_SIMPLE_TYPE_3...
     d                 c                   3002
     d  XML_SCHEMAP_SRC_SIMPLE_TYPE_4...
     d                 c                   3003
     d  XML_SCHEMAP_SRC_RESOLVE...
     d                 c                   3004
     d  XML_SCHEMAP_SRC_RESTRICTION_BASE_OR_SIMPLETYPE...
     d                 c                   3005
     d  XML_SCHEMAP_SRC_LIST_ITEMTYPE_OR_SIMPLETYPE...
     d                 c                   3006
     d  XML_SCHEMAP_SRC_UNION_MEMBERTYPES_OR_SIMPLETYPES...
     d                 c                   3007
     d  XML_SCHEMAP_ST_PROPS_CORRECT_1...
     d                 c                   3008
     d  XML_SCHEMAP_ST_PROPS_CORRECT_2...
     d                 c                   3009
     d  XML_SCHEMAP_ST_PROPS_CORRECT_3...
     d                 c                   3010
     d  XML_SCHEMAP_COS_ST_RESTRICTS_1_1...
     d                 c                   3011
     d  XML_SCHEMAP_COS_ST_RESTRICTS_1_2...
     d                 c                   3012
     d  XML_SCHEMAP_COS_ST_RESTRICTS_1_3_1...
     d                 c                   3013
     d  XML_SCHEMAP_COS_ST_RESTRICTS_1_3_2...
     d                 c                   3014
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_1...
     d                 c                   3015
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_1_1...
     d                 c                   3016
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_1_2...
     d                 c                   3017
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_1...
     d                 c                   3018
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_2...
     d                 c                   3019
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_3...
     d                 c                   3020
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_4...
     d                 c                   3021
     d  XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_5...
     d                 c                   3022
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_1...
     d                 c                   3023
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_1...
     d                 c                   3024
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_1_2...
     d                 c                   3025
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_2...
     d                 c                   3026
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_1...
     d                 c                   3027
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_3...
     d                 c                   3028
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_4...
     d                 c                   3029
     d  XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_5...
     d                 c                   3030
     d  XML_SCHEMAP_COS_ST_DERIVED_OK_2_1...
     d                 c                   3031
     d  XML_SCHEMAP_COS_ST_DERIVED_OK_2_2...
     d                 c                   3032
     d  XML_SCHEMAP_S4S_ELEM_NOT_ALLOWED...
     d                 c                   3033
     d  XML_SCHEMAP_S4S_ELEM_MISSING...
     d                 c                   3034
     d  XML_SCHEMAP_S4S_ATTR_NOT_ALLOWED...
     d                 c                   3035
     d  XML_SCHEMAP_S4S_ATTR_MISSING...
     d                 c                   3036
     d  XML_SCHEMAP_S4S_ATTR_INVALID_VALUE...
     d                 c                   3037
     d  XML_SCHEMAP_SRC_ELEMENT_1...
     d                 c                   3038
     d  XML_SCHEMAP_SRC_ELEMENT_2_1...
     d                 c                   3039
     d  XML_SCHEMAP_SRC_ELEMENT_2_2...
     d                 c                   3040
     d  XML_SCHEMAP_SRC_ELEMENT_3...
     d                 c                   3041
     d  XML_SCHEMAP_P_PROPS_CORRECT_1...
     d                 c                   3042
     d  XML_SCHEMAP_P_PROPS_CORRECT_2_1...
     d                 c                   3043
     d  XML_SCHEMAP_P_PROPS_CORRECT_2_2...
     d                 c                   3044
     d  XML_SCHEMAP_E_PROPS_CORRECT_2...
     d                 c                   3045
     d  XML_SCHEMAP_E_PROPS_CORRECT_3...
     d                 c                   3046
     d  XML_SCHEMAP_E_PROPS_CORRECT_4...
     d                 c                   3047
     d  XML_SCHEMAP_E_PROPS_CORRECT_5...
     d                 c                   3048
     d  XML_SCHEMAP_E_PROPS_CORRECT_6...
     d                 c                   3049
     d  XML_SCHEMAP_SRC_INCLUDE...
     d                 c                   3050
     d  XML_SCHEMAP_SRC_ATTRIBUTE_1...
     d                 c                   3051
     d  XML_SCHEMAP_SRC_ATTRIBUTE_2...
     d                 c                   3052
     d  XML_SCHEMAP_SRC_ATTRIBUTE_3_1...
     d                 c                   3053
     d  XML_SCHEMAP_SRC_ATTRIBUTE_3_2...
     d                 c                   3054
     d  XML_SCHEMAP_SRC_ATTRIBUTE_4...
     d                 c                   3055
     d  XML_SCHEMAP_NO_XMLNS...
     d                 c                   3056
     d  XML_SCHEMAP_NO_XSI...
     d                 c                   3057
     d  XML_SCHEMAP_COS_VALID_DEFAULT_1...
     d                 c                   3058
     d  XML_SCHEMAP_COS_VALID_DEFAULT_2_1...
     d                 c                   3059
     d  XML_SCHEMAP_COS_VALID_DEFAULT_2_2_1...
     d                 c                   3060
     d  XML_SCHEMAP_COS_VALID_DEFAULT_2_2_2...
     d                 c                   3061
     d  XML_SCHEMAP_CVC_SIMPLE_TYPE...
     d                 c                   3062
     d  XML_SCHEMAP_COS_CT_EXTENDS_1_1...
     d                 c                   3063
     d  XML_SCHEMAP_SRC_IMPORT_1_1...
     d                 c                   3064
     d  XML_SCHEMAP_SRC_IMPORT_1_2...
     d                 c                   3065
     d  XML_SCHEMAP_SRC_IMPORT_2...
     d                 c                   3066
     d  XML_SCHEMAP_SRC_IMPORT_2_1...
     d                 c                   3067
     d  XML_SCHEMAP_SRC_IMPORT_2_2...
     d                 c                   3068
     d  XML_SCHEMAP_INTERNAL...                                                 Non W3C
     d                 c                   3069
     d  XML_SCHEMAP_NOT_DETERMINISTIC...
     d                 c                   3070
     d  XML_SCHEMAP_SRC_ATTRIBUTE_GROUP_1...
     d                 c                   3071
     d  XML_SCHEMAP_SRC_ATTRIBUTE_GROUP_2...
     d                 c                   3072
     d  XML_SCHEMAP_SRC_ATTRIBUTE_GROUP_3...
     d                 c                   3073
     d  XML_SCHEMAP_MG_PROPS_CORRECT_1...
     d                 c                   3074
     d  XML_SCHEMAP_MG_PROPS_CORRECT_2...
     d                 c                   3075
     d  XML_SCHEMAP_SRC_CT_1...
     d                 c                   3076
     d  XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_1_3...
     d                 c                   3077
     d  XML_SCHEMAP_AU_PROPS_CORRECT_2...
     d                 c                   3078
     d  XML_SCHEMAP_A_PROPS_CORRECT_2...
     d                 c                   3079
     d  XML_SCHEMAP_C_PROPS_CORRECT...
     d                 c                   3080
     d  XML_SCHEMAP_SRC_REDEFINE...
     d                 c                   3081
     d  XML_SCHEMAP_SRC_IMPORT...
     d                 c                   3082
     d  XML_SCHEMAP_WARN_SKIP_SCHEMA...
     d                 c                   3083
     d  XML_SCHEMAP_WARN_UNLOCATED_SCHEMA...
     d                 c                   3084
     d  XML_SCHEMAP_WARN_ATTR_REDECL_PROH...
     d                 c                   3085
     d  XML_SCHEMAP_WARN_ATTR_POINTLESS_PROH...
     d                 c                   3086
     d  XML_SCHEMAP_AG_PROPS_CORRECT...
     d                 c                   3087
     d  XML_SCHEMAP_COS_CT_EXTENDS_1_2...
     d                 c                   3088
     d  XML_SCHEMAP_AU_PROPS_CORRECT...
     d                 c                   3089
     d  XML_SCHEMAP_A_PROPS_CORRECT_3...
     d                 c                   3090
     d  XML_SCHEMAP_COS_ALL_LIMITED...
     d                 c                   3091
     d  XML_SCHEMATRONV_ASSERT...
     d                 c                   4000
     d  XML_SCHEMATRONV_REPORT...
     d                 c                   4001
     d  XML_MODULE_OPEN...
     d                 c                   4900
     d  XML_MODULE_CLOSE...
     d                 c                   4901
     d  XML_CHECK_FOUND_ELEMENT...
     d                 c                   5000
     d  XML_CHECK_FOUND_ATTRIBUTE...
     d                 c                   5001
     d  XML_CHECK_FOUND_TEXT...
     d                 c                   5002
     d  XML_CHECK_FOUND_CDATA...
     d                 c                   5003
     d  XML_CHECK_FOUND_ENTITYREF...
     d                 c                   5004
     d  XML_CHECK_FOUND_ENTITY...
     d                 c                   5005
     d  XML_CHECK_FOUND_PI...
     d                 c                   5006
     d  XML_CHECK_FOUND_COMMENT...
     d                 c                   5007
     d  XML_CHECK_FOUND_DOCTYPE...
     d                 c                   5008
     d  XML_CHECK_FOUND_FRAGMENT...
     d                 c                   5009
     d  XML_CHECK_FOUND_NOTATION...
     d                 c                   5010
     d  XML_CHECK_UNKNOWN_NODE...
     d                 c                   5011
     d  XML_CHECK_ENTITY_TYPE...
     d                 c                   5012
     d  XML_CHECK_NO_PARENT...
     d                 c                   5013
     d  XML_CHECK_NO_DOC...
     d                 c                   5014
     d  XML_CHECK_NO_NAME...
     d                 c                   5015
     d  XML_CHECK_NO_ELEM...
     d                 c                   5016
     d  XML_CHECK_WRONG_DOC...
     d                 c                   5017
     d  XML_CHECK_NO_PREV...
     d                 c                   5018
     d  XML_CHECK_WRONG_PREV...
     d                 c                   5019
     d  XML_CHECK_NO_NEXT...
     d                 c                   5020
     d  XML_CHECK_WRONG_NEXT...
     d                 c                   5021
     d  XML_CHECK_NOT_DTD...
     d                 c                   5022
     d  XML_CHECK_NOT_ATTR...
     d                 c                   5023
     d  XML_CHECK_NOT_ATTR_DECL...
     d                 c                   5024
     d  XML_CHECK_NOT_ELEM_DECL...
     d                 c                   5025
     d  XML_CHECK_NOT_ENTITY_DECL...
     d                 c                   5026
     d  XML_CHECK_NOT_NS_DECL...
     d                 c                   5027
     d  XML_CHECK_NO_HREF...
     d                 c                   5028
     d  XML_CHECK_WRONG_PARENT...
     d                 c                   5029
     d  XML_CHECK_NS_SCOPE...
     d                 c                   5030
     d  XML_CHECK_NS_ANCESTOR...
     d                 c                   5031
     d  XML_CHECK_NOT_UTF8...
     d                 c                   5032
     d  XML_CHECK_NO_DICT...
     d                 c                   5033
     d  XML_CHECK_NOT_NCNAME...
     d                 c                   5034
     d  XML_CHECK_OUTSIDE_DICT...
     d                 c                   5035
     d  XML_CHECK_WRONG_NAME...
     d                 c                   5036
     d  XML_CHECK_NAME_NOT_NULL...
     d                 c                   5037
     d  XML_I18N_NO_NAME...
     d                 c                   6000
     d  XML_I18N_NO_HANDLER...
     d                 c                   6001
     d  XML_I18N_EXCESS_HANDLER...
     d                 c                   6002
     d  XML_I18N_CONV_FAILED...
     d                 c                   6003
     d  XML_I18N_NO_OUTPUT...
     d                 c                   6004
     d  XML_BUF_OVERFLOW...
     d                 c                   7000

      * xmlGenericErrorFunc:
      * @ctx:  a parsing context
      * @msg:  the message
      * @...:  the extra arguments of the varags to format the message
      *
      * Signature of the function to use when there is an error and
      * no parsing or validity context available .

     d xmlGenericErrorFunc...
     d                 s               *   based(######typedef######)
     d                                     procptr

      * xmlStructuredErrorFunc:
      * @userData:  user provided data for the error callback
      * @error:  the error being raised.
      *
      * Signature of the function to use when there is an error and
      * the module handles the new error reporting mechanism.

     d xmlStructuredErrorFunc...
     d                 s               *   based(######typedef######)
     d                                     procptr

      * Use the following function to reset the two global variables
      * xmlGenericError and xmlGenericErrorContext.

     d xmlSetGenericErrorFunc...
     d                 pr                  extproc('xmlSetGenericErrorFunc')
     d  ctx                            *   value                                void *
     d  handler                            value like(xmlGenericErrorFunc)

     d initGenericErrorDefaultFunc...
     d                 pr                  extproc(
     d                                      'initGenericErrorDefaultFunc')
     d  handler                            like(xmlGenericErrorFunc)

     d xmlSetStructuredErrorFunc...
     d                 pr                  extproc('xmlSetStructuredErrorFunc')
     d  ctx                            *   value                                void *
     d  handler                            value like(xmlGenericErrorFunc)

      * Default message routines used by SAX and Valid context for error
      * and warning reporting.
      *
      * These are vararg functions.
      * The following prototypes support up to 8 pointer arguments.
      * Other argument signature can be achieved by defining alternate
      *   prototypes redirected to the same function.

     d xmlParserError  pr                  extproc('xmlParserError')
     d  ctx                            *   value                                void *
     d  msg                            *   value options(*string)               const char *
     d  handler                            value like(xmlGenericErrorFunc)
     d  arg1                           *   value options(*string: *nopass)
     d  arg2                           *   value options(*string: *nopass)
     d  arg3                           *   value options(*string: *nopass)
     d  arg4                           *   value options(*string: *nopass)
     d  arg5                           *   value options(*string: *nopass)
     d  arg6                           *   value options(*string: *nopass)
     d  arg7                           *   value options(*string: *nopass)
     d  arg8                           *   value options(*string: *nopass)

     d xmlParserWarning...
     d                 pr                  extproc('xmlParserWarning')
     d  ctx                            *   value                                void *
     d  msg                            *   value options(*string)               const char *
     d  handler                            value like(xmlGenericErrorFunc)
     d  arg1                           *   value options(*string: *nopass)
     d  arg2                           *   value options(*string: *nopass)
     d  arg3                           *   value options(*string: *nopass)
     d  arg4                           *   value options(*string: *nopass)
     d  arg5                           *   value options(*string: *nopass)
     d  arg6                           *   value options(*string: *nopass)
     d  arg7                           *   value options(*string: *nopass)
     d  arg8                           *   value options(*string: *nopass)

     d xmlParserValidityError...
     d                 pr                  extproc('xmlParserValidityError')
     d  ctx                            *   value                                void *
     d  msg                            *   value options(*string)               const char *
     d  handler                            value like(xmlGenericErrorFunc)
     d  arg1                           *   value options(*string: *nopass)
     d  arg2                           *   value options(*string: *nopass)
     d  arg3                           *   value options(*string: *nopass)
     d  arg4                           *   value options(*string: *nopass)
     d  arg5                           *   value options(*string: *nopass)
     d  arg6                           *   value options(*string: *nopass)
     d  arg7                           *   value options(*string: *nopass)
     d  arg8                           *   value options(*string: *nopass)

     d xmlParserValidityWarning...
     d                 pr                  extproc('xmlParserValidityWarning')
     d  ctx                            *   value                                void *
     d  msg                            *   value options(*string)               const char *
     d  handler                            value like(xmlGenericErrorFunc)
     d  arg1                           *   value options(*string: *nopass)
     d  arg2                           *   value options(*string: *nopass)
     d  arg3                           *   value options(*string: *nopass)
     d  arg4                           *   value options(*string: *nopass)
     d  arg5                           *   value options(*string: *nopass)
     d  arg6                           *   value options(*string: *nopass)
     d  arg7                           *   value options(*string: *nopass)
     d  arg8                           *   value options(*string: *nopass)

     d xmlParserPrintFileInfo...
     d                 pr                  extproc('xmlParserPrintFileInfo')
     d  input                              value like(xmlParserInputPtr)

     d xmlParserPrintFileContext...
     d                 pr                  extproc('xmlParserPrintFileContext')
     d  input                              value like(xmlParserInputPtr)

      * Extended error information routines

     d xmlGetLastError...
     d                 pr                  extproc('xmlGetLastError')
     d                                     like(xmlErrorPtr)

     d xmlResetLastError...
     d                 pr                  extproc('xmlResetLastError')

     d xmlCtxtGetLastError...
     d                 pr                  extproc('xmlCtxtGetLastError')
     d                                     like(xmlErrorPtr)
     d  ctx                            *   value                                void *

     d xmlCtxtResetLastError...
     d                 pr                  extproc('xmlCtxtResetLastError')
     d  ctx                            *   value                                void *

     d xmlResetError   pr                  extproc('xmlResetError')
     d  err                                value like(xmlErrorPtr)

     d xmlCopyError    pr            10i 0 extproc('xmlCopyError')
     d  from                               value like(xmlErrorPtr)
     d  to                                 value like(xmlErrorPtr)

      /endif                                                                    XML_ERROR_H__
