from ldt.auth.views import login as pf_login
from ldt.text import VERSION_STR

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.views.generic import RedirectView


js_info_dict = {
    'packages': ('django.contrib.admin',), 
}

urlpatterns = [
    # Example:

    # Uncomment the admin/doc line below and add 'django.contrib.admindocs' 
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    url(r'^admin/', include(admin.site.urls)),
    url(r'^i18n/', include('django.conf.urls.i18n')),

    url(r'^ldt/', include('ldt.ldt_utils.urls')),
    url(r'^user/', include('ldt.user.urls')),
    url(r'^api/', include('ldt.api.urls')),
    url(r'^api/' + VERSION_STR + '/text/', include('ldt.text.urls')),

    url(r'^auth_accounts/', include('registration.backends.simple.urls')),

    url(r'^accounts/', include('social.apps.django_app.urls', namespace='social')),
    url(r'^accounts/login/$',pf_login,{'template_name': 'registration/login.html'},name='auth_login'),
    url(r'^oauth/', include('oauth_provider.urls')),
    
    
    url(r'^/?$', RedirectView.as_view(url='ldt')),
    
    url(r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),
    url(r'^hashcut/', include('hashcut.urls')),
    url(r'^composer/', include('metadatacomposer.urls')),
]

urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)