# -*- coding: utf-8 -*-
import os, logging

SITE_ID = 1


BASE_DIR = os.path.dirname(os.path.abspath(__file__)).rstrip("/")+"/"
BASE_URL = '/'
PLATFORM_BASE_URL = '/'
LOGIN_REDIRECT_URL = '/ldt'
LOGOUT_REDIRECT_URL = '/ldt'
WEB_URL = ''
WEB_AUTH = [] # example [{'REGEX': 'localhost/~ymh/platform', 'NAME': 'ymh', 'PASSWORD': 'ymh'}]
STATIC_URL = BASE_URL + 'static/site/'


STREAM_SRC_PREFIX = ""

BASE_STATIC_URL = WEB_URL + BASE_URL + 'static/'
BASE_STATIC_ROOT = os.path.abspath(BASE_DIR + "../../web/static/").rstrip("/")+"/"

STREAM_URL = BASE_STATIC_URL + "/content/"

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = BASE_STATIC_ROOT + "media/"


# Absolute path to the directory that static files (js, css, swf...)
# DO NOT forget to do command line ./manage.py collectstatic to gather static media into the web/static folder
STATIC_ROOT = BASE_STATIC_ROOT + "site/"

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'vu6choo7ahk4loaj4lie1thiegh0cae4quohtohnee7ooshaN1'

# PATH to the ffmpeg executable, used to know automatically the media file duration 
FFMPEG_PATH = ""


CONTENT_ROOT = BASE_STATIC_ROOT + "content/"

# PATH where uploaded media are put.
STREAM_PATH = CONTENT_ROOT

LDT_MEDIA_PREFIX = STATIC_URL + 'ldt/'


DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'postgres',                      # Or path to database file if using sqlite3.
        'USER': 'postgres',                      # Not used with sqlite3.
        'PASSWORD': '',                  # Not used with sqlite3.
        'HOST': 'db',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.dummy.DummyCache',
    }
}

DEBUG = True
TEMPLATE_DEBUG = DEBUG

LOG_FILE = os.path.abspath(os.path.join(BASE_DIR,"../../run/log/log.txt"))
LOG_LEVEL = logging.DEBUG
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'formatters' : {
        'simple' : {
            'format': "%(asctime)s - %(levelname)s : %(message)s",
        },
        'semi-verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(message)s'
        },                    
    },
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'filters': ['require_debug_false'],
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'stream_to_console': {
            'level': LOG_LEVEL,
            'class': 'logging.StreamHandler'
        },
        'file': {
            'level': LOG_LEVEL,
            'class': 'logging.FileHandler',
            'filename': LOG_FILE,
            'formatter': 'semi-verbose',
        },
    },
    'loggers': {
        'django.db.backends':{
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },                
        'django.request': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        'ldt': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
    }
}


ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

GOOGLE_ANALYTICS_CODE = '%(google_analytics_code)s'

EMAIL_USE_TLS = False
EMAIL_HOST = ''
EMAIL_HOST_USER = ''
EMAIL_HOST_PASSWORD = ''
EMAIL_PORT = 25 

ACCOUNT_ACTIVATION_DAYS = 7
REGISTRATION_OPEN = False

LDT_MAX_SEARCH_NUMBER = 50
LDT_MAX_FRAGMENT_PER_SEARCH = 3
LDT_RESULTS_PER_PAGE = 1
LDT_JSON_DEFAULT_INDENT = 0
LDT_MAX_CONTENTS_PER_PAGE = 5
LDT_MAX_PROJECTS_PER_PAGE = 5
LDT_FRONT_MEDIA_PER_PAGE = 9

EMPTY_MEDIA_EXTERNALID = None

AUTO_INDEX_AFTER_SAVE = True

FORBIDDEN_STREAM_URL = "%(forbidden_stream_url)s"

AUDIO_RECORD_URL = "%(audio_record_url)s"

FRONT_TAG_LIST = [u"Enmi 2011", u"film", u"conférence"]

HAYSTACK_CONNECTIONS = {
    'default': {
        #for elasticsearch use ldt.indexation.backends.elasticsearch_backend.ElasticsearchSearchEngine
        'ENGINE': 'ldt.indexation.backends.elasticsearch_backend.ElasticsearchSearchEngine',
        'URL': 'es:9200/',
        'INDEX_NAME': 'ldt',
    },
}

LDT_INDEXATION_INSERT_BATCH_SIZE = 5000