# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

def update_oauth_provider_migration(apps, schema_editor):
    from django.db.migrations.recorder import MigrationRecorder
    count = MigrationRecorder.Migration.objects.filter(app='oauth_provider', name='0001_correct_oauth_provider_secret_size').count()
    for r in MigrationRecorder.Migration.objects.filter(app='oauth_provider', name='0001_correct_oauth_provider_secret_size')[0:count-1]:
        r.delete()
    MigrationRecorder.Migration.objects.filter(app='oauth_provider', name='0001_correct_oauth_provider_secret_size').update(app='ldtplatform')

def update_oauth_provider_migration_back(apps, schema_editor):
    from django.db.migrations.recorder import MigrationRecorder
    MigrationRecorder.Migration.objects.filter(app='ldtplatform', name='0001_correct_oauth_provider_secret_size').update(app='oauth_provider')


class Migration(migrations.Migration):

    dependencies = [
        ('ldtplatform', '0001_correct_oauth_provider_secret_size'),
    ]

    operations = [
        migrations.RunPython(update_oauth_provider_migration, update_oauth_provider_migration_back),
    ]
