from django.conf.urls.defaults import url
from ldt.ldt_utils.models import Content
from tastypie.resources import ModelResource

        
class ContentResource(ModelResource):
    class Meta:
        allowed_methods = ['get']
        resource_name = 'contents'
        queryset = Content.objects.all()
        excludes = ['media_obj']

    def override_urls(self):
        # WARNING : in tastypie <= 1.0, override_urls is used instead of prepend_urls. From 1.0.0, prepend_urls will be prefered and override_urls deprecated 
        return [
            url(r"^(?P<resource_name>%s)/(?P<iri_id>[\w\d_.-]+)/$" % self._meta.resource_name, self.wrap_view('dispatch_detail'), name="api_dispatch_detail"),
        ]
            