# -*- coding: utf-8 -*-
'''
Created on Jul 23, 2012

@author: ymh
'''

from haystack import indexes

from ldt.ldt_utils.models import Segment, Content
from ldt.text.models import Annotation


class SegmentIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    iri_id = indexes.CharField(model_attr='iri_id', indexed=False, stored=True)
    project_id = indexes.CharField(model_attr='project_id', indexed=False, stored=True, null=True)
    ensemble_id = indexes.CharField(model_attr='ensemble_id', indexed=False, stored=True)
    cutting_id = indexes.CharField(model_attr='cutting_id', indexed=False, stored=True)
    element_id = indexes.CharField(model_attr='element_id', indexed=False, stored=True)
    tags = indexes.CharField(model_attr='get_tags', stored=True)
    title = indexes.CharField(model_attr='title', stored=True)
    abstract = indexes.CharField(model_attr='abstract', stored=True)
    duration = indexes.IntegerField(model_attr='duration', indexed=False, stored=True)
    author = indexes.CharField(model_attr='author', stored=True, null=True)
    start_ts = indexes.IntegerField(model_attr='start_ts', indexed=False, stored=True)
    date = indexes.CharField(model_attr='date', stored=True)
    
    def get_model(self):
        return Segment
    
    def prepare_tags(self, obj):
        if hasattr(obj, 'tag_list'):
            if obj.tag_list is not None:
                obj.tags = None # To avoid a second and useless db request
                return ",".join(obj.tag_list)
        return ",".join([tag.name for tag in obj.tags.all()])
    
    def index_queryset(self, using=None):
        "Used when the entire index for model is updated."
        return self.get_model().objects.prefetch_related("tags")
    
    
class AnnotationIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    tags = indexes.CharField(model_attr='tags', indexed=True, stored=False)
    title = indexes.CharField(model_attr='title', indexed=True, stored=True)
    abstract = indexes.CharField(model_attr='description', indexed=True, stored=False)
    text_field = indexes.CharField(model_attr='text', indexed=True, stored=False)
    annotation_id = indexes.CharField(model_attr='external_id', indexed=False, stored=True)

    def get_model(self):
        return Annotation
    
    def prepare_tags(self, obj):
        return ",".join([tag.name for tag in obj.tags.all()])
    
    def index_queryset(self, using=None):
        "Used when the entire index for model is updated."
        return self.get_model().objects.prefetch_related("tags")


class ContentIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    tags = indexes.CharField(model_attr='get_tags', indexed=True, stored=False, null=True)
    title = indexes.CharField(model_attr='title', indexed=True, stored=True)
    abstract = indexes.CharField(model_attr='description', indexed=True, stored=False, null=True)
    
    def get_model(self):
        return Content
    
    def prepare_tags(self, obj):
        return ",".join([tag.name for tag in obj.tags.all()])
    
    def index_queryset(self, using=None):
        "Used when the entire index for model is updated."
        return self.get_model().objects.prefetch_related("tags")
