from django.utils import translation

class LanguageMiddleware(object):

    def process_request(self, request):
        if request.user.is_authenticated():
            profile = request.user.get_profile()
            language = profile.language
            translation.activate(language)
            request.LANGUAGE_CODE = translation.get_language()
            
            request.user.is_regular = profile.is_regular
            
        
            