"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.contrib.auth import get_user_model

from ldt.ldt_utils.models import Media
from ldt.test.client import Client
from ldt.test.testcases import TestCase


User = get_user_model()

class MediaTest(TestCase):
    
    fixtures = ['testing_sites_data.json', 'user_data.json']
    
    def setUp(self):
        self.client = Client()
        User.objects.create_superuser('blop', 'blop@blop.com', 'blop')
        
        _ = self.client.login(username='blop', password='blop')
        
        self.user = User()
        self.user.username = 'blop'
    
    def test_create_media(self):
        self.media1, created = Media.objects.get_or_create(src = "http://www.youtube.com/watch?v=O2G-PEtyKSY", id = 1)
        self.assertEqual(Media.objects.get(id=self.media1.id), self.media1)
        
    def test_del_media(self):
        self.media2 = Media()
        self.media2.id = 2
        self.media2.save()
        
        self.media2.delete()
        
        with self.assertRaises(Media.DoesNotExist):
            Media.objects.get(id=self.media2.id)
            