var display_state = "player";

function toggle_display() {
	$j.each(["player","seo_body","seo_meta","links"], function(i,display_str) {

		var div_selector = "#"+display_str+"_code";
		if(display_str == display_state) {
			$j(div_selector).show();
		}
		else {
			$j(div_selector).hide();
		}
	});
}

function init_events(){
	toggle_display();
	mode1();
	$j("#iframe_premode").toggle(false);
	$j("#div_premode").toggle(false);
	$j("#embed_personnalisation").toggle(false);
	$j("#optionsExpArrow").toggle(true);
	$j("#optionsCollArrow").toggle(false);	
	$j("#preModeExpArrow").toggle(true);
	$j("#preModeCollArrow").toggle(false);
	$j("#createannotation_block").toggle(false);
	$j("#player_id_code").focus();
	$j("#player_id_code").select();
	$j("#polemic_options").toggle(false);
	$j("#sparkline_options").toggle(false);
	$j("#social_options").toggle(false);
	$j("#displayPolemicOptions").toggle(false);
	$j("#displaySparklineOptions").toggle(false);
	$j("#polemic_default_color").val("#585858");
	$j("#polemic_found_color").val("#fc00ff");
	$j("#sparkline_line_color").val("#7492b4");
	$j("#sparkline_fill_color").val("#aeaeb8");
	
    $j("#project_id_select").click(function(){
    	$j("#project_id_input").focus();
    	$j("#project_id_input").select();
    });
	
	$j('.ldt_json_link').click(function(e) {
    	e.preventDefault();
 		link = $j(e.target);
 		$j("#res_link_{{player_id}}").load(link.attr("href"));
 		$j("#res_link_{{player_id}}").show();
 		return false;
    });

    $j('#player_button').click(function(e) {
    	display_state = "player";
    	toggle_display();
    });
    $j('#seo_body_button').click(function(e) {
    	display_state = "seo_body";
    	toggle_display();
    });
    $j('#seo_meta_button').click(function(e) {
    	display_state = "seo_meta";
    	toggle_display();
    });
    $j('#links_button').click(function(e) {
    	display_state = "links";
    	toggle_display();
    });

   $j("#copy_button").click(function(e) {
 	   alert($j("#"+display_state+"_code").html());
   });
   
   $j("#player_button").click(function(){
	   $j("#player_id_code").focus();
	   $j("#player_id_code").select();
   });
	
   $j("#seo_body_button").click(function(){
	   $j("#seo_body_id_code").focus();
      	$j("#seo_body_id_code").select();
   
   });
   
   $j("#seo_meta_button").click(function(){
	   $j("#seo_meta_id_code").focus();
      	$j("#seo_meta_id_code").select();
   }); 
   
   $j('#links_button').click(function() {
	   var range = document.createRange();
	   range.selectNode(document.getElementById('links_code'));
	   window.getSelection().addRange(range);
   });
   
   $j('#displayPreMode').click(function(){
	   var type_embed=document.getElementById("type_embed_div");
	   if(type_embed.checked){
		   $j("#div_premode").slideToggle("fast");
		  
	   }
	   else{
		   $j("#iframe_premode").slideToggle("fast");
	   }
	   $j("#preModeExpArrow").toggle();
	   $j("#preModeCollArrow").toggle();
	   
	});
   
   $j("#displayEmbedOptions").click(function(){
	   $j("#embed_personnalisation").slideToggle("fast");
	   $j("#optionsExpArrow").toggle();
	   $j("#optionsCollArrow").toggle();
	   
   });
   
   $j("#displayPolemicOptions").click(function(){
	  $j("#polemic_options").slideToggle("fast");
   });
    
   $j("#displaySparklineOptions").click(function(){
		  $j("#sparkline_options").slideToggle("fast");
   });
}

function generate_base_embed_code(){
	base='\
<div> \n \
		<div id="'+player_id+'_embed" style="float:left; width:'+player_width+';" class="iri_player_embed">\n\
		</div>\n\
<script type="text/javascript" src="'+WEB_URL+LDT_MEDIA_PREFIX+'metadataplayer/LdtPlayer-core.js"></script>\n\
<script type="text/javascript">\n\
	if (typeof jQuery == "undefined") {\n\
		jQuery = IriSP.jQuery;\n\
	}\n\
	var metadatas = {metadata: {url: "'+json_url+'"}};\n\
	var metadata_key = "metadata";\n\
	IriSP.libFiles.defaultDir = "'+WEB_URL+LDT_MEDIA_PREFIX+'js/";\n\
	IriSP.libFiles.locations.jwPlayerSWF = "'+WEB_URL+LDT_MEDIA_PREFIX+'swf/player.swf";\n\
	IriSP.libFiles.locations.recordMicSwf = "'+WEB_URL+LDT_MEDIA_PREFIX+'swf/record_mic.swf";\n\
	IriSP.libFiles.locations.zeroClipboardSwf = "'+WEB_URL+LDT_MEDIA_PREFIX+'swf/ZeroClipboard10.swf";\n\
	IriSP.libFiles.locations.cssjQueryUI = "'+WEB_URL+LDT_MEDIA_PREFIX+'css/jq-css/themes/base/jquery-ui.css"\n\
	IriSP.language = "'+LANGUAGE_CODE+'";\n\
\n\
	IriSP.widgetsDir = "'+WEB_URL+LDT_MEDIA_PREFIX+'metadataplayer";\n\
	var _metadata = {\n\
    	url: metadatas[metadata_key].url + "?callback=?",\n\
    	format: "ldt"\n\
	};\n\
	var _config = {\n\
    	width: "'+player_width+'",\n\
    	container: "'+player_id+'_embed",\n\
    	css: "'+WEB_URL+LDT_MEDIA_PREFIX+'metadataplayer/LdtPlayer-core.css",\n\
    	default_options: {\n\
        metadata: _metadata\n\
    },\n';
	
	return base;
   
}

function generate_widget_code(){
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var slideshare_val=document.getElementById('slideshare_checkbox');
	var social_val=document.getElementById('social_checkbox');
	var annotation_val=document.getElementById('annotation_checkbox');
	var tweet_val=document.getElementById('tweet_checkbox');
	var segments_val=document.getElementById('segments_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	var sparkline_val=document.getElementById('sparkline_checkbox');
	var tagcloud_val=document.getElementById('tagcloud_checkbox');

	widget_code='\
	widgets: [\n\
		{\n';
	if (external_url!='None'){
		widget_code+='\
			type: "AutoPlayer",\n\
			video: "'+external_url+'",\n';
	}
	else{	
		widget_code+='\
			type: "JwpPlayer",\n\
	        streamer: function(_url) {\n\
	        var _matches = _url.match(/^[^\\/]+\\/\\/[^\\/]+\\/[^\\/]+\\//);\n\
	        if (_matches) {\n\
	                return _matches[0];\n\
	        } else {\n\
	                return _url;\n\
	        }\n\
	        },\n\
	        live: true,\n\
	        provider: "rtmp",\n';
	}
	
	widget_code+='\
			height: 300,\n\
	        autostart: true\n\
	    }';
	if (polemic_val.checked){	
		defaultcolor= $j("#polemic_default_color").val();
		foundcolor=$j("#polemic_found_color").val();
		widget_code+='\
	    ,{\n\
	        type: "Polemic",\n\
			annotation_type: false,\n\
			defaultcolor: "'+defaultcolor+'",\n\
			foundcolor: "'+foundcolor+'"\n\
		}';
	}
	
	if(sparkline_val.checked){
		linecolor=$j("#sparkline_line_color").val();
		fillcolor=$j("#sparkline_fill_color").val();
		widget_code+=',{\n\
            type: "Sparkline",\n\
			lineColor: "'+linecolor+'",\n\
			fillColor: "'+fillcolor+'"\n\
        }';
	}
	
	if(segments_val.checked){
		widget_code+=',{\n\
	        type: "Segments",\n\
	        annotation_type: ["chap","dÃ©coupage"]\n\
	    }';
	}
	widget_code+=',{\n\
	        type: "Slider"\n\
	    },{\n\
	        type: "Controller"\n\
	    },{\n\
	        type: "Mediafragment"\n\
	    }';
	if(slideshare_val.checked){
		widget_code+='\
		,{\n\
	        type: "Slideshare",\n\
	        container: "Slideshare_ext",\n\
	        embed_width: 400,\n\
	        embed_height: 334,\n\
	        annotation_type: "slide"\n\
		}';
	}
	
	if(social_val.checked){
		show_url=document.getElementById("show_url_checkbox");
		show_twitter=document.getElementById("show_twitter_checkbox");
		show_fb=document.getElementById("show_fb_checkbox");
		show_gplus=document.getElementById("show_gplus_checkbox");
		show_mail=document.getElementById("show_mail_checkbox");

		widget_code+='\
		,{\n\
	        type: "Social",\n\
	        container: "Social_ext",\n\
	        url: document.location.href.replace(/#.*$/,""),\n\
	        text: document.title,\n';
		
		if(show_url.checked){
			widget_code+='\
			show_url: true,\n';
		}
		else{
			widget_code+='\
			show_url: false,\n';
		}
		if(show_twitter.checked){
			widget_code+='\
			show_twitter: true,\n';
		}
		else{
			widget_code+='\
			show_twitter: false,\n';
		}
		if(show_fb.checked){
			widget_code+='\
			show_fb: true,\n';
		}
		else{
			widget_code+='\
			show_fb: false,\n';
		}
		if(show_gplus.checked){
			widget_code+='\
			show_gplus: true,\n';
		}
		else{
			widget_code+='\
			show_gplus: false,\n';
		}
		if(show_mail.checked){
			widget_code+='\
			show_mail: true\n';
		}
		else{
			widget_code+='\
			show_mail: false\n';
		}
		
		widget_code+='}';
	}
	if(annotation_val.checked){
		widget_code+='\
		,{\n\
	        type: "Annotation",\n\
	        start_minimized: true,\n\
	        site_name : "Lignes de Temps",\n\
	        annotation_type: ["chap","dÃ©coupage"]\n\
	    }';
	}
	if(tweet_val.checked){
		widget_code+='\
		,{\n\
	        type: "Tweet",\n\
	        hide_timeout: 5000\n\
	    }';
	}
	
	if(annotationslist_val.checked){
		widget_code+=',{\n\
	        type: "AnnotationsList",\n\
	        container: "AnnotationsList_ext",\n\
	        ajax_granularity : 300000,\n\
	        default_thumbnail : "'+WEB_URL+LDT_MEDIA_PREFIX+'css/imgs/video_sequence.png",\n\
	        show_audio: true,\n\
	        rtmp_streamer: "rtmp://media.iri.centrepompidou.fr/ddc_micro_record/"\n\
	    }';
	}
	
	if(tagcloud_val.checked){
		widget_code+=',{\n\
			type: "Tagcloud",\n\
		}';
	}
	
	widget_code+=']\n\
		};\n';
        
        return widget_code;
		
}

function generate_div_code(){
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var slideshare_val=document.getElementById('slideshare_checkbox');
	var social_val=document.getElementById('social_checkbox');
	code=generate_base_embed_code();
	code+=generate_widget_code();
	code+='\n\
	_myPlayer = new IriSP.Metadataplayer(_config);\n\
	</script>\n';
	if(social_val.checked){
		code+='\
	<div id="Social_ext" class="Ldt-TraceMe Ldt-Widget" style="float:right; width:400px; height:24px;" widget-type="Social">\n\
	</div>\n';
	}
	if(slideshare_val.checked){
		code+='\
	<div id="Slideshare_ext" class="ext_widget Ldt-TraceMe Ldt-Widget" style="float:left; width:400px;" widget-type="Slideshare">\n\
    </div>\n';
	}
	
	if(annotationslist_val.checked){
		code+='\
	<div id="AnnotationsList_ext" class="ext_widget Ldt-TraceMe Ldt-Widget" style="float:left; width:400px;" widget-type="AnnotationsList"></div>\n';
	}

	code+='\
</div>\n';
	return code;	
}

function put_new_code(){
	var type_embed=document.getElementById("type_embed_div");
	wrapper = "wrapper_"+player_id;
	wrapper_id = "#"+wrapper;
	var element = document.getElementById(wrapper);
	var code_embed=document.getElementById("player_id_code");
	if(type_embed.checked){
		var new_code=generate_div_code();
		if(element.style.display=="block"){
			$j(wrapper_id).html(new_code);
		}
	
	}
	else{
		var new_code=generate_iframe_code();
		if(element.style.display=="block"){
			display_iframe_player();
		}
	}
	code_embed.value= new_code;
	$j("#player_id_code").focus();
	$j("#player_id_code").select();	
}

function div_event(){
	$j("#iframe_premode").toggle(false);
	$j("#div_premode").toggle(false);
	$j("#preModeExpArrow").toggle(true);
	$j("#preModeCollArrow").toggle(false);
	$j("#createannotation_block").toggle(false);
	put_new_code();
}

function toggle() {
	wrapper="wrapper_"+player_id;
	wrapper_id="#"+wrapper;
	var element = document.getElementById(wrapper);
	var text = document.getElementById("displayPlayer");
	var type_embed=document.getElementById("type_embed_div");
	if(element.style.display==="none") {
		if (type_embed.checked){
			var new_code=generate_div_code();
			$j(wrapper_id).html(new_code);
		}
		else{
			display_iframe_player();
		}
    	element.style.display="block";
		text.innerHTML = translate_hide;
  	}
	else {
		$j(wrapper_id).html('');
    	element.style.display="none";
		text.innerHTML = translate_show;
	}
} 

function display_polemic(){
	$j("#displayPolemicOptions").slideToggle("fast");
	$j("#polemic_options").toggle(false);
}

function display_sparkline(){
	$j("#displaySparklineOptions").slideToggle("fast");		
	$j("#sparkline_options").toggle(false);
}

function display_social(){
	$j("#social_options").slideToggle("fast");
}
function mode1(){
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var slideshare_val=document.getElementById('slideshare_checkbox');
	var social_val=document.getElementById('social_checkbox');
	var annotation_val=document.getElementById('annotation_checkbox');
	var tweet_val=document.getElementById('tweet_checkbox');
	var segments_val=document.getElementById('segments_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	var sparkline_val=document.getElementById('sparkline_checkbox');
	var tagcloud_val=document.getElementById('tagcloud_checkbox');
	var createannotation_val=document.getElementById('createannotation_checkbox');

	var type_embed=document.getElementById("type_embed_div");

	if(type_embed.checked){
		createannotation_val.checked=false;
	}
	else{
		createannotation_val.checked=true;
	}
	$j("#displayPolemicOptions").toggle(false);
	$j("#displaySparklineOptions").toggle(false);
	$j("#social_options").toggle(false);
	$j("#sparkline_options").toggle(false);
	polemic_val.checked=false;
	segments_val.checked=true;
	annotationslist_val.checked=false;
	slideshare_val.checked=false;
	social_val.checked=false;
	annotation_val.checked=false;
	tweet_val.checked=false;
	sparkline_val.checked=false;
	tagcloud_val.checked=false;
	put_new_code();
}

function mode2(){
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var slideshare_val=document.getElementById('slideshare_checkbox');
	var social_val=document.getElementById('social_checkbox');
	var annotation_val=document.getElementById('annotation_checkbox');
	var tweet_val=document.getElementById('tweet_checkbox');
	var segments_val=document.getElementById('segments_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	var sparkline_val=document.getElementById('sparkline_checkbox');
	var tagcloud_val=document.getElementById('tagcloud_checkbox');
	var createannotation_val=document.getElementById('createannotation_checkbox');
	var type_embed=document.getElementById("type_embed_div");	
	$j("#displayPolemicOptions").toggle(false);
	$j("#displaySparklineOptions").toggle(false);
	$j("#social_options").toggle(false);
	$j("#sparkline_options").toggle(false);
	display_polemic();
	display_sparkline();
	if(type_embed.checked){
		createannotation_val.checked=false;
	}
	else{
		createannotation_val.checked=true;
	}
	polemic_val.checked=true;
	segments_val.checked=true;
	annotationslist_val.checked=false;
	slideshare_val.checked=false;
	social_val.checked=false;
	annotation_val.checked=true;
	sparkline_val.checked=true;
	tweet_val.checked=false;
	tagcloud_val.checked=false;
	put_new_code();
	
}

function mode3(){
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var slideshare_val=document.getElementById('slideshare_checkbox');
	var social_val=document.getElementById('social_checkbox');
	var annotation_val=document.getElementById('annotation_checkbox');
	var tweet_val=document.getElementById('tweet_checkbox');
	var segments_val=document.getElementById('segments_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	var sparkline_val=document.getElementById('sparkline_checkbox');
	var tagcloud_val=document.getElementById('tagcloud_checkbox');
	var createannotation_val=document.getElementById('createannotation_checkbox');
	var type_embed=document.getElementById("type_embed_div");	
	$j("#displayPolemicOptions").toggle(false);
	$j("#displaySparklineOptions").toggle(false);
	$j("#social_options").toggle(false);
	$j("#sparkline_options").toggle(false);
	display_polemic();
	display_social();
	display_sparkline();
	if(type_embed.checked){
		createannotation_val.checked=false;
	}
	else{
		createannotation_val.checked=true;
	}
	polemic_val.checked=true;
	segments_val.checked=true;
	annotationslist_val.checked=true;
	slideshare_val.checked=false;
	social_val.checked=true;
	annotation_val.checked=true;
	tweet_val.checked=false;
	sparkline_val.checked=true;
	tagcloud_val.checked=true;
	put_new_code();
	
}
function iframe_event(){
	$j("#createannotation_block").toggle(true);
	var element = document.getElementById(wrapper);
	var createannotation_val=document.getElementById('createannotation_checkbox');
	createannotation_val.checked=true;
	if(element.style.display=="block"){
		display_iframe_player();
	}
	iframe_code=generate_iframe_code();
	$j("#player_id_code").val(iframe_code);
	$j("#player_id_code").focus();
	$j("#player_id_code").select();

}	

function generate_iframeUrl(){
	var createannotation_val=document.getElementById('createannotation_checkbox');
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var slideshare_val=document.getElementById('slideshare_checkbox');
	var social_val=document.getElementById('social_checkbox');
	var annotation_val=document.getElementById('annotation_checkbox');
	var tweet_val=document.getElementById('tweet_checkbox');
	var segments_val=document.getElementById('segments_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	var sparkline_val=document.getElementById('sparkline_checkbox');
	var tagcloud_val=document.getElementById('tagcloud_checkbox');
	iframeUrl= iframe_url;
	if(createannotation_val.checked){
		iframeUrl+="&createannotation=True";
	}
	if (polemic_val.checked){
		iframeUrl+="&polemic=all";
	}
	else{
		iframeUrl+="&polemic=False";
	}
	if(annotationslist_val.checked){
		iframeUrl+="&annotations_list=True";
	}
	if(slideshare_val.checked){
		iframeUrl+="&slideshare=True";
	}
	if(social_val.checked){
		iframeUrl+="&social=True";
	}
	if(tweet_val.checked){
		iframeUrl+="&tweet=True";
	}
	if(segments_val.checked){
		iframeUrl+="&segments=True";
	}
	if(sparkline_val.checked){
		iframeUrl+="&sparkline=True";
	}
	if(tagcloud_val.checked){
		iframeUrl+="&tagcloud=True";
	}
	iframeUrl+= "&show_mic_record="+show_mic_record+"";

  return iframeUrl;
}

function generate_iframe_code(){
	var createannotation_val=document.getElementById('createannotation_checkbox');
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	iframeUrl=generate_iframeUrl();
	player_width=570;
	player_height=430;
	if (createannotation_val.checked){
		player_height+=281;
	}
	if(annotationslist_val.checked){
		player_width+=430;
	}
	if(polemic_val.checked){
		player_height+=100;
		
	}
	if(show_mic_record!='False'){
		
		player_height+=55;
	}
 	iframe_code="<iframe src='"+iframeUrl+"' width='"+player_width+"' height='"+player_height+"' seamless='seamless'></iframe>";

 	return iframe_code;
}

function display_iframe_player(){
	var createannotation_val=document.getElementById('createannotation_checkbox');
	var annotationslist_val=document.getElementById('annotations_list_checkbox');
	var polemic_val=document.getElementById('polemic_checkbox');
	var code_embed=document.getElementById("player_id_code");
	$j("#iframe_premode").toggle(false);
	$j("#div_premode").toggle(false);	
	$j("#preModeExpArrow").toggle(true);
	$j("#preModeCollArrow").toggle(false);
	wrapper = "wrapper_"+player_id;
	wrapper_id = "#"+wrapper;
	iframeUrl= generate_iframeUrl();
	player_width=570;
	player_height=430;
	if (createannotation_val.checked){
		player_height+=281;
	}
	if(annotationslist_val.checked){
		player_width+=430;
	}
	if(polemic_val.checked){
		player_height+=100;
		
	}
	if(show_mic_record!='False'){
		
		player_height+=55;
	}
	frame = document.createElement("iframe");
    frame.width = player_width;
    frame.height = player_height;
    frame.src = iframeUrl;
    frame.frameBorder = 0;
   	frame.seamless = "seamless";
   	$j(wrapper_id).html(frame);
}

function set_default_color(code){
	$j("#polemic_default_color").val("#"+code);
	put_new_code();
}

function set_found_color(code){
	$j("#polemic_found_color").val("#"+code);
	put_new_code();
}

function set_line_color(code){
	$j("#sparkline_line_color").val("#"+code);
	put_new_code();
}

function set_fill_color(code){
	$j("#sparkline_fill_color").val("#"+code);
	put_new_code();
}

