from ldt import settings
import httplib2
import re
import urlparse

def request_with_auth(url, method='GET'):
    h = httplib2.Http()
    web_auth = settings.WEB_AUTH if settings.WEB_AUTH else []
    for entry in web_auth:
        if not isinstance(entry, dict):
            continue
        regex = entry.get('REGEX', None)
        if regex and re.search(regex, url, re.IGNORECASE):
            h.add_credentials(entry.get('NAME', ''), entry.get('PASSWORD', ''), entry.get('DOMAIN', ''))
            break
            
    return h.request(url, method)


def is_absolute(url):
    return bool(urlparse.urlparse(url).scheme)