"""
Call this like ``python create_python_env.py``; it will
refresh the project-boot.py script

-prerequisite:

- virtualenv

- python project-boot.py --unzip-setuptools --no-site-packages --clear --type-install=local <path_to_venv>

"""

import os
import subprocess
import re
import sys


here = os.path.dirname(os.path.abspath(__file__))
base_dir = here
script_name = os.path.join(base_dir, 'project-boot.py')

import virtualenv

# things to install
# - psycopg2 -> pip
# - PIL -> pip
# - pyxml -> pip
# - 4Suite-xml - easy_install ftp://ftp.4suite.org/pub/4Suite/4Suite-XML-1.0.2.tar.bz2
# - pylucene  - script

src_base = os.path.join(here,"res","src").replace("\\","/")
lib_path = os.path.abspath(os.path.join(here,"res","lib")).replace("\\","/")

EXTRA_TEXT  = "import sys\n"
EXTRA_TEXT += "sys.path.append('%s')\n" % (lib_path)
f = open(os.path.join(os.path. os.path.join(os.path.dirname(os.path.abspath(__file__)),"res"),'res_create_env.py'), 'r')
EXTRA_TEXT += f.read()
EXTRA_TEXT += "\n"
EXTRA_TEXT += "RES_ENV = ResourcesEnv('%s')\n" % (src_base)


def main():
    python_version = ".".join(map(str,sys.version_info[0:2]))
    text = virtualenv.create_bootstrap_script(EXTRA_TEXT, python_version=python_version)
    if os.path.exists(script_name):
        f = open(script_name)
        cur_text = f.read()
        f.close()
    else:
        cur_text = ''
    print 'Updating %s' % script_name
    if cur_text == 'text':
        print 'No update'
    else:
        print 'Script changed; updating...'
        f = open(script_name, 'w')
        f.write(text)
        f.close()

if __name__ == '__main__':
    main()

