from ldt.security.utils import protect_models, unprotect_models, _thread_locals

class SecurityMiddleware(object):
    
    def process_request(self, request):
        if not hasattr(_thread_locals, 'user'):
            _thread_locals.user = request.user
            protect_models()
    
    def process_response(self, request, response):
        
        if hasattr(_thread_locals, 'user'):            
            unprotect_models()
            del _thread_locals.user
                
        return response
    