from django.core.management.base import BaseCommand #@UnresolvedImport
from ldt.ldt_utils.models import Content
from ldt.ldt_utils.stat import update_stat_content
from ldt.management.utils import show_progress

class Command(BaseCommand):
    help = 'Computes annotation for all contents'    
    
    def handle(self, *args, **options):             
               
        writer = None
        total = Content.objects.count() #@UndefinedVariable
       
        for i,c in enumerate(Content.objects.select_related('stat_annotation').all()): #@UndefinedVariable
            writer = show_progress(i+1, total, "content %d : %s" % (c.id,c.title), 50, writer)
            update_stat_content(c)
            
        return None
    