from django.core.management.base import BaseCommand
from ldt.ldt_utils.models import Content, Project
from ldt.ldt_utils.contentindexer import ContentIndexer, ProjectIndexer
from django.conf import settings
from django.db import models
from django.contrib.sites.models import Site

class Command(BaseCommand):
    help = 'set the site domain to the right value according to the django settings'
    
    def handle(self, *args, **options):
        site = Site.objects.get(id=settings.SITE_ID)
        web_url = settings.WEB_URL
        domain_area = web_url.split("//",1)
        domain = domain_area[1]
        if site.domain!=domain:
            site.domain = domain
            site.save()
        if site.name!=domain:
            site.name=domain
            site.save()