# -*- coding: utf-8 -*-
# ldt_utils/siteconfig.py
# NOTE: Import this file in your urls.py or some place before
#       any code relying on settings is imported.
from django.contrib.sites.models import Site

from djblets.siteconfig.models import SiteConfiguration
from djblets.siteconfig.django_settings import apply_django_settings, get_django_defaults, generate_defaults

settings_map = {
    # siteconfig key    settings.py key
    'front_tag_list':        'FRONT_TAG_LIST',
}

defaults = {
    'front_tag_list': [u"Enmi 2011", u"tcymhkhjvrv", u"film", u"conférence"],
}
defaults.update(generate_defaults(settings_map))

def load_site_config():
    """Sets up the SiteConfiguration, provides defaults and syncs settings."""
    try:
        siteconfig = SiteConfiguration.objects.get_current()
    except SiteConfiguration.DoesNotExist:
        # Either warn or just create the thing. Depends on your app
        siteconfig = SiteConfiguration(site=Site.objects.get_current(), version="1.0")

    if not siteconfig.get_defaults():
        siteconfig.add_defaults(defaults)
        siteconfig.add_defaults(get_django_defaults())
    
    apply_django_settings(siteconfig, settings_map)
    apply_django_settings(siteconfig)
    
    
load_site_config()