from ldt.security import  set_current_user, del_current_user, _thread_locals

class SecurityMiddleware(object):
    
    def process_request(self, request):
        if not hasattr(_thread_locals, 'user'):
            set_current_user(request.user)
    
    def process_response(self, request, response):
        
        if hasattr(_thread_locals, 'user'):            
            del_current_user()
                
        return response
    