from ldt.user.forms import AdminUserCreationForm, AdminUserChangeForm
from ldt.user.models import GroupProfile, LdtUser

from django.contrib import admin
from django.contrib.auth.admin import UserAdmin
from django.contrib.auth.models import Group
from django.utils.translation import gettext_lazy as _
from guardian.admin import GuardedModelAdmin


class GroupProfileInline(admin.StackedInline):
    model = GroupProfile


class GroupAdmin(GuardedModelAdmin):
    def add_view(self, *args, **kwargs):
        self.inlines = []
        return super(GroupAdmin, self).add_view(*args, **kwargs)

    def change_view(self, *args, **kwargs):
        self.inlines = [GroupProfileInline]
        return super(GroupAdmin, self).change_view(*args, **kwargs)


class LdtUserAdmin(UserAdmin):
    form = AdminUserChangeForm
    add_form = AdminUserCreationForm
    fieldsets = tuple(list(UserAdmin.fieldsets) + [(_('profile'), {'fields':('language','image')})])

admin.site.unregister(Group)
admin.site.register(Group, GroupAdmin)

admin.site.register(LdtUser, LdtUserAdmin)