from django.conf.urls import patterns, url, include
from ldt.management import test_ldt
import ldt.ldt_utils.views.embed.v1.views as embed_v1

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('ldt.ldt_utils',
    url(r'^searchInit/(?P<field>.*)/(?P<query>.*)$', 'views.lignesdetemps.search_init'),
    url(r'^searchForm/$', 'views.workspace.search_form'),
    url(r'^published/$', 'views.workspace.published_project'),
    url(r'^groups/$', 'views.workspace.groups', name="groups-view"),
    url(r'^get_group_projects/$', 'views.group.get_group_projects_view'),
    url(r'^search/$', 'views.workspace.search_index'),
    url(r'^search/(?P<field>.*)/(?P<query>.*)$', 'views.lignesdetemps.search_index_get'),
    url(r'^searchLdt/(?P<field>.*)/(?P<query>.*)$', 'views.lignesdetemps.search_ldt'),
    url(r'^searchSeg/(?P<field>.*)/(?P<query>.*)$', 'views.lignesdetemps.search_segments'),
    url(r'^index/(?P<url>.*)$', 'views.lignesdetemps.index'),
    url(r'^init/(?P<method>.*)/(?P<url>.*)$', 'views.lignesdetemps.init', name='ldt_init'),
    url(r'^ldt/(?P<url>.*)$', 'views.lignesdetemps.ldt'),
    url(r'^search/loading/$', 'views.workspace.loading'),
    url(r'^create/(?P<iri_id>.*)$', 'views.project.create_project'),
    url(r'^copy/(?P<ldt_id>.*)/(?P<group_id>.*)$', 'views.project.copy_project'),
    url(r'^copy/(?P<ldt_id>.*)$', 'views.project.copy_project'),
    url(r'^update/(?P<ldt_id>.*)$', 'views.project.update_project'),
    url(r'^cljson/id/(?P<id>.*)$', 'views.json.project_json_id', name="projectjson_id"),
    url(r'^cljson/externalid/(?P<id>.*)$', 'views.json.project_json_externalid', name="projectjson_externalid"),
    url(r'^cljson/idcutting/(?P<id>.*)/(?P<cutting_id>.*)$', 'views.json.project_json_cutting_id'),
    url(r'^rdf/id/(?P<ldt_id>.*)$', 'views.rdf.project_annotations_rdf'),
    url(r'^workspace/?$', "views.workspace.home", name="root-view"),
    url(r'^filterprojects/_(?P<filter>[\w \%\_\-\+]*?)/(?P<is_owner>true|false)/(?P<status>\d)$', "views.project.projects_filter",),
    url(r'^filterprojects/_(?P<filter>[\w \%\_\-\+]*?)/(?P<is_owner>true|false)/(?P<status>\d)/(?P<id_group>.*)$', "views.project.projects_filter",),
    url(r'^filtercontents/_(?P<filter_c>[\w \%\_\-\+]*?)/$', "views.content.contents_filter",),
    url(r'^filtergroups/_(?P<filter>[\w \%\_\-\+]*?)/$', "views.group.groups_filter",),
    url(r'filtershare/_(?P<filter>[\w \%\_\-\+]*?)/(?P<use_groups>true|false)$', "views.workspace.share_filter"),
    url(r'^embedpopup/?$', embed_v1.ConfigViewV1.as_view(), name="embed_config_v1"),
    url(r'^embediframe/?$', embed_v1.IframeViewV1.as_view(), name="embed_iframe_v1"),
    url(r'^embed/', include('ldt.ldt_utils.views.embed.urls')),
    url(r'^embedldt/(?P<id>.*)$', 'views.lignesdetemps.embed_ldt', name='embed_ldt'),
    url(r'^segment/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.lignesdetemps.index_segment'),
    url(r'^segmentInit/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.lignesdetemps.init_segment'),
    url(r'^segmentLdt/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.lignesdetemps.ldt_segment'),
    url(r'^segmentHighlight/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.lignesdetemps.highlight_segment'),
    url(r'^createGroup/$', 'views.group.create_group'),
    url(r'^updateGroup/(?P<group_id>.*)$', 'views.group.update_group'),
    url(r'^$', 'views.front.front_home', name='front_home'),
    url(r'^front/groups/$', 'views.front.group_list'),
    url(r'^front/group/(?P<group_id>.*)/medias/$', 'views.front.group_medias'),
    url(r'^front/group/(?P<group_id>.*)/$', 'views.front.group_info'),
    url(r'^front/player/all/(?P<content_iri_id>.*)/$', 'views.front.all_projects_for_media'),
    url(r'^front/player/(?P<content_iri_id>.*)/$', 'views.front.annot_content'),
    url(r'^front/player/(?P<content_iri_id>.*)/(?P<project_id>.*)/(?P<cutting_id>.*)$', 'views.front.annot_content'),
    url(r'^front/player/(?P<content_iri_id>.*)/(?P<project_id>.*)$', 'views.front.annot_content', name='front_player_content_project'),
    url(r'^front/search/$', 'views.front.search_index'),
    url(r'^front/medias', 'views.front.all_contents'),
    url(r'^mashupbytag/$', 'views.json.mashup_by_tag'),
    url(r'^deletesegment/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.workspace.delete_segment', name="delete_segment"),
)

urlpatterns += patterns('',
    url('^jsi18n/?$', 'django.views.i18n.javascript_catalog', name='ldt.jsi18n.all'),
    url('^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', {'domain':'djangojs'}, name='ldt.jsi18n'),
)


if test_ldt():
    urlpatterns += patterns('ldt.ldt_utils',
        #url(r'^space/content/$', 'views.list_content'),
        url(r'^space/content/create/$', 'views.content.write_content'),
        url(r'^space/content/update/(?P<iri_id>[\w-]+)$', 'views.content.write_content'),
        #url(r'^space/ldt/$', 'views.list_ldt'),
        url(r'^space/ldt/indexproject/(?P<id>.*)$', 'views.lignesdetemps.index_project', name='index_project'),
        url(r'^space/ldt/indexprojectfull/(?P<id>.*)$', 'views.lignesdetemps.index_project', {'full': True}, name='index_project_full'),
        url(r'^space/ldt/init/(?P<method>.*)/(?P<url>.+)$', 'views.lignesdetemps.init', name='space_ldt_init'),
        url(r'^space/ldt/project/(?P<id>.*)$', 'views.lignesdetemps.ldt_project'),
        url(r'^space/ldt/create/$', 'views.project.create_ldt_view'),
        url(r'^space/ldt/created_done/$', 'views.project.created_ldt'),
        url(r'^space/ldt/save/$', 'views.lignesdetemps.save_ldt_project'),
        url(r'^space/ldt/publish/(?P<id>[\w-]*)$', 'views.project.publish'),
        url(r'^space/ldt/unpublish/(?P<id>[\w-]*)$', 'views.project.unpublish'),
        url(r'^space/upload/$', 'views.content.upload'),
        url(r'^space/removetempfile/$', 'views.content.remove_temp_file'),
        url(r'^space/getduration/$', 'views.content.get_duration'),
        url(r'^chunked_uploads/', include('chunked_uploads.urls')),
)
