__all__ = ["VERSION", "get_version", "__version__"]

VERSION = (1, 56, 9, "final", 0)


def get_version():
    version = '%s.%s' % (VERSION[0], VERSION[1])
    if VERSION[2]:
        version = '%s.%s' % (version, VERSION[2])
    if VERSION[3:] == ('alpha', 0):
        version = '%s pre-alpha' % version
    else:
        if VERSION[3] != 'final':
            version = '%s %s %s' % (version, VERSION[3], VERSION[4])
    return version


__version__ = get_version()

# solve initialization pb
# The pb comes from the initialization of the middlewares
# The is a potential circular reference pb between the following modules : security, indexation model.
# the cause comes from the fact that at one moment, the User model is referenced, using the new django 1.5 django.contrib.auth.get_user_model method
# This method cause the load of all installed apps, causing the circular dependency problem.
# the following code force a "pre-load" of all installed app, solving the dependecy pb.
# TODO: remove this by reworking ldt dependencies
#from django.db.models.loading import get_models
#_ = get_models()
