"""
Some useful form widgets
"""

from django.contrib.admin.widgets import AdminSplitDateTime
from django.forms.widgets import TimeInput
from django.utils.safestring import mark_safe
from django.utils.translation import ugettext as _
import time
import math
import logging


class LdtSplitDateTime(AdminSplitDateTime):
    """
    A widget that extend the AdminSplitDateTime to improve the html outputted
    """
    
    def format_output(self, rendered_widgets):
        return mark_safe(u'<div class="ldtdatetime"><div class="ldtdate"><div class="ldtdatetitle">%s</div> <div class="ldtdatefield">%s</div></div><div class="ldttime"><div class="ldttimetitle">%s</div> <div class="ldttimefield">%s</div></div></div>' % \
            (_('Date'), rendered_widgets[0], _('Time'), rendered_widgets[1]))


class LdtParseVideoDuration(TimeInput):
    """
    A widget allowing to enter the duration format : XhMM, XXhMM, XXXs, XXXsec, HH:MM, HH:MM:SS, HH:MM:SS.SS
    """

    def value_from_datadict(self, data, files, name):
        dur = data['content-duration']
        for format in self.format:
            try:
                dur = time.strptime(dur, format)
                dur = dur.tm_hour*3600 + dur.tm_min*60 + dur.tm_sec
                dur = dur*1000
            except:
                logging.debug("trying next format")
        data['content-duration']=dur
        return data['content-duration']