# -*- coding: utf-8 -*-
'''
Created on Feb 22, 2013

@author: ymh
'''
from django.db import models
from haystack import signals
from ldt.ldt_utils.models import Segment
from ldt.text.models import Annotation

class LdtSignalProcessor(signals.BaseSignalProcessor):
    
    def __connect_signals(self, klass):
        models.signals.post_save.connect(self.handle_save, sender=klass)
        models.signals.post_delete.connect(self.handle_delete, sender=klass)        

    def __disconnect_signals(self, klass):
        models.signals.post_save.disconnect(self.handle_save, sender=klass)
        models.signals.post_delete.disconnect(self.handle_delete, sender=klass)

    
    def setup(self):        
        self.__connect_signals(Segment)
        self.__connect_signals(Annotation)



    def teardown(self):
        self.__disconnect_signals(Annotation)
        self.__disconnect_signals(Segment)
        