from django.conf.urls.defaults import patterns, url
from django.contrib import admin
from django.shortcuts import render_to_response
from django.template import RequestContext
from ldt.ldt_utils.contentindexer import ContentIndexer, ProjectIndexer
from ldt.ldt_utils.fileimport import FileImport, FileImportError
from ldt.ldt_utils.forms import LdtImportForm, ReindexForm, StatAnnotationForm
from ldt.ldt_utils.models import Content, Project, Media, Author
from ldt.ldt_utils.stat import update_stat_content
from guardian.admin import GuardedModelAdmin
from django.http import HttpResponse
from StringIO import StringIO
from django.core.management import call_command
import logging


class ProjectAdmin(GuardedModelAdmin):
    pass

class AuthorAdmin(GuardedModelAdmin):
    pass

class MediaAdmin(GuardedModelAdmin):
    readonly_fields = ['src_hash']

class ContentAdmin(GuardedModelAdmin):
    
    def import_file(self, request):
        if request.method == 'POST':
            form = LdtImportForm(request.POST, request.FILES)
            if form.is_valid():
                filetoprocess = form.cleaned_data['importFile']
                flatten = form.cleaned_data['flatten']
                videoPath = form.cleaned_data['videoPath']
                # fi = None
                fi = FileImport(filetoprocess, videoPath, flatten)
                try:
                    fi.process_file()
                    args = {'message': "File imported"}
                except FileImportError:
                    non_field_errors = form.non_field_errors()
                    non_field_errors.append("Error when importing : unknown file type")
                    form._errors["__all__"] = non_field_errors
                    args = {'message': "Can not import file, unknown file type", 'form': form}
                    
            else:
                non_field_errors = form.non_field_errors()
                non_field_errors.append("Error when importing : invalid form")
                form._errors["__all__"] = non_field_errors
                args = {'message': "Error when importing : invalid form", 'form': form}
        else:
            form = LdtImportForm()
            args = {'form': form, 'current_app': self.admin_site.name, 'current_action' : 'import_file'}
        return render_to_response('admin/ldt_utils/content/upload_form.html', args, context_instance=RequestContext(request))

    def reindex(self, request):
        message = None
        if request.method == "POST":
            form = ReindexForm(request.POST)
            if form.is_valid():    
                contentList = form.cleaned_data["contents"]
                indexer = ContentIndexer(contentList)
                indexer.index_all()
                
                index_projects = form.cleaned_data["index_projects"]
                if index_projects:
                    projectList = Project.objects.filter(contents__in=contentList, state=2).distinct() #filter(contents__in=contentList) @UndefinedVariable
                    indexer = ProjectIndexer(projectList)
                    indexer.index_all()
                message = "Indexation ok : " + repr(form.cleaned_data["contents"]) 
                form = ReindexForm()
                # except Exception, inst:
                    # non_field_errors = form.non_field_errors()
                    # non_field_errors.append("Error when reindexing : " + cgi.escape(repr(inst)))
                    # form._errors["__all__"] = non_field_errors
                    #message = "ERROR : " + repr(non_field_errors)
        else:
            form = ReindexForm()
    
        return render_to_response('admin/ldt_utils/content/reindex_form.html', {'form': form, 'message':message, 'current_app': self.admin_site.name, 'current_action' : 'reindex' }, context_instance=RequestContext(request))

    def stats_annotations(self, request):
        
        message = None
        if request.method == "POST":
            form = StatAnnotationForm(request.POST)
            
            if form.is_valid():
                
                if form.cleaned_data['choose_all']:
                    contents = Content.objects.all()
                else:
                    contents = form.cleaned_data['contents']
                
                for content in contents:
                    update_stat_content(content)
                message = "Stats computed for :" + repr(contents)
        else:
            form = StatAnnotationForm()
            
        return render_to_response('admin/ldt_utils/content/stats_form.html', {'form': form, 'message':message, 'current_app': self.admin_site.name, 'current_action' : 'stats' }, context_instance=RequestContext(request))
    
    
    def dumpdata(self, request):
        # do we dump the datas ?
        dump_str = request.REQUEST.get("dump")
        app_str = request.REQUEST.get("app", "")
        dump_bool = False
        if dump_str:
            dump_bool = {'true': True, 'false': False, "0": False, "1": True}.get(dump_str.lower())
        if dump_bool:
            content = StringIO()
            if app_str=="":
                call_command("dumpdata", indent=1, stdout=content)
            else:
                call_command("dumpdata", app_str, indent=1, stdout=content)
            content.seek(0)
            out = content.getvalue()
            content.close()
            res = HttpResponse(out, mimetype='application/json')
            res["Content-Disposition"] = "attachment; filename=dumpdata_ldt.json"
            return res
        return render_to_response('admin/ldt_utils/content/dumpdata.html', {}, context_instance=RequestContext(request))
      

    def get_urls(self):
        urls = super(ContentAdmin, self).get_urls()
        content_urls = patterns('',
            url(r'^reindex/$', self.admin_site.admin_view(self.reindex), name="ldt_content_reindex"),
            url(r'^import/$', self.admin_site.admin_view(self.import_file), name="ldt_content_import_file"),
            url(r'^stats/$', self.admin_site.admin_view(self.stats_annotations), name="ldt_project_compute_stats"),
            url(r'^dumpdata/$', self.admin_site.admin_view(self.dumpdata), name="ldt_admin_dump_data"),
        )
        return content_urls + urls


admin.site.register(Project, ProjectAdmin)
admin.site.register(Content, ContentAdmin)
admin.site.register(Media, MediaAdmin)
admin.site.register(Author, AuthorAdmin)
