# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('user', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='ldtuser',
            name='external_id',
            field=models.CharField(max_length=50, verbose_name='external id', blank=True),
        ),
        migrations.AlterField(
            model_name='ldtuser',
            name='first_name',
            field=models.CharField(max_length=150, verbose_name='first name', blank=True),
        ),
        migrations.AlterField(
            model_name='ldtuser',
            name='last_name',
            field=models.CharField(max_length=150, verbose_name='last name', blank=True),
        ),
        migrations.AlterField(
            model_name='ldtuser',
            name='username',
            field=models.CharField(error_messages={b'unique': 'A user with that username already exists.'}, max_length=50, validators=[django.core.validators.RegexValidator(b'^[\\w.@+-]+$', 'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.')], help_text='Required. 50 characters or fewer. Letters, digits and @/./+/-/_ only.', unique=True, verbose_name='username'),
        ),
    ]
