from django.contrib.auth import REDIRECT_FIELD_NAME
from django.contrib.auth.views import login as django_login
from ldt.auth import social_list
from ldt.user.forms import AdminAuthenticationForm

def login(request, template_name='registration/login.html',
          redirect_field_name=REDIRECT_FIELD_NAME,
          authentication_form=AdminAuthenticationForm,
          current_app=None):
    extra_context = {'social_list': social_list}
    
    return django_login(request, template_name, redirect_field_name, authentication_form, current_app, extra_context)
