$(document).ready(function () {
    $('.graph_annotation').each(function(_i) {
        var _values = this.innerHTML.split(','),
            _nb = _values.length,
            _width = $(this).parent().parent().parent().width() - 8,
            _height = $(this).height(),
            _max = _values.reduce(function(_a,_b) {
                return Math.max(_a,_b);
            }, 0);
        this.innerHTML = '';
        if (_max) {
            var _x = function(_p) {
                    return _p * _width / _nb;
                },
                _y = function(_p) {
                    return _height * ( 1 - _p / _max );
                },
                _d = _values.map(function(_v,_k) {
                    return ( _k == 0 ?
                        "M" + _x(_k) + " " + _y(_v) :
                        "C" + _x(_k-.5) + " " + _y(_values[_k - 1])
                        + " " + + _x(_k-.5) + " " + _y(_v)
                        + " " + + _x(_k) + " " + _y(_v)
                        ) ;
                }).join("") + "L" + _width + " " + _height + "L0 " + _height;
            var _paper = new Raphael(this,_width,_height);
            _paper.rect(0,0,_width,_height).attr({
                "stroke" : "none",
                "fill" : "#ffffff",
                "opacity" : .8,
            });
            _paper.path(_d).attr({
                "fill" : "#adadad",
                "stroke" : "#808080"
            });
        }
    });

    $(".polemics li").each(function(_i,_e) {
        var _sp = $(_e).find("span");
        if (parseInt(_sp.text())) {
            var _newWidth = (2 + _sp.width());
            if ($(_e).width() < _newWidth) {
                $(_e).css("width",_newWidth+"px");
            }
        } else {
            $(_e).detach();
        }
    });
});